/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.file;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.drm.playready.PlayReadyEncryptor;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.drm.playready.PlayReadyMediaInfo;
import com.wowza.wms.drm.playready.PlayReadyUtils;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.smoothstreaming.file.HTTPStreamerSmoothStreamerIndexEntry;
import com.wowza.wms.httpstreamer.smoothstreaming.file.IHTTPStreamerSmoothStreamerIndex;
import com.wowza.wms.httpstreamer.smoothstreaming.file.SmoothStreamerIndexBaseFrag;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerApplicationContextSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.httpstreamer.smoothstreaming.util.LiveStreamPacketizerSmoothStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.stream.IMediaStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPStreamerSmoothStreamerIndexBase
implements IHTTPStreamerSmoothStreamerIndex {
    public static final String SINGLEBITRATE = "video";
    public static final String AUDIOBITRATE = "audio";
    public static final String VIDEOBITRATE = "video";
    protected String titleStr = "";
    protected IHTTPStreamerApplicationContext appContext = null;
    protected IApplicationInstance appInstance = null;
    protected String streamExt = null;
    protected String streamName = null;
    protected IMediaStream stream = null;
    protected Map<String, HTTPStreamerSmoothStreamerIndexEntry> videoEntries = new HashMap<String, HTTPStreamerSmoothStreamerIndexEntry>();
    protected Map<String, HTTPStreamerSmoothStreamerIndexEntry> audioEntries = new HashMap<String, HTTPStreamerSmoothStreamerIndexEntry>();
    protected List<String> videoOrder = new ArrayList<String>();
    protected String primaryVideo = null;
    protected String primaryAudio = null;
    protected String contextStr = "";
    protected int smoothStreamingMediaMajorVersion = 2;
    protected int smoothStreamingMediaMinorVersion = 1;
    protected IHTTPStreamerSession httpStreamerSession = null;
    protected PlayReadyKeyInfo playReadyKeyInfo = null;
    protected PlayReadyEncryptor playReadyEncryptorAudio = null;
    protected PlayReadyEncryptor playReadyEncryptorVideo = null;

    @Override
    public List<String> getStreamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.streamName);
        return arrayList;
    }

    @Override
    public void init(IHTTPStreamerSession iHTTPStreamerSession, IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, String string, String string2) {
        this.appContext = iHTTPStreamerApplicationContext;
        this.appInstance = iHTTPStreamerApplicationContext.getAppInstance();
        this.streamExt = string;
        this.streamName = string2;
        this.httpStreamerSession = iHTTPStreamerSession;
        WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
        WMSProperties wMSProperties2 = this.appInstance.getProperties();
        this.smoothStreamingMediaMajorVersion = wMSProperties.getPropertyInt("smoothStreamingMediaMajorVersion", this.smoothStreamingMediaMajorVersion);
        this.smoothStreamingMediaMinorVersion = wMSProperties.getPropertyInt("smoothStreamingMediaMinorVersion", this.smoothStreamingMediaMinorVersion);
        this.smoothStreamingMediaMajorVersion = wMSProperties2.getPropertyInt("smoothStreamingMediaMajorVersion", this.smoothStreamingMediaMajorVersion);
        this.smoothStreamingMediaMinorVersion = wMSProperties2.getPropertyInt("smoothStreamingMediaMinorVersion", this.smoothStreamingMediaMinorVersion);
        this.contextStr = this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + string2;
        PlayReadyKeyInfo playReadyKeyInfo = LiveStreamPacketizerSmoothStreamerUtils.getEncInfo(this.appInstance, string2);
        if (playReadyKeyInfo == null) {
            playReadyKeyInfo = new PlayReadyKeyInfo();
        }
        this.appInstance.getModFunctions().onHTTPSmoothStreamingPlayReadyCreateVOD((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession, playReadyKeyInfo);
        if (!playReadyKeyInfo.isComplete()) {
            playReadyKeyInfo = null;
        }
        this.setPlayReadyKeyInfo(playReadyKeyInfo);
    }

    protected void setPlayReadyKeyInfo(PlayReadyKeyInfo playReadyKeyInfo) {
        this.playReadyKeyInfo = playReadyKeyInfo;
        if (playReadyKeyInfo != null) {
            this.playReadyEncryptorAudio = new PlayReadyEncryptor();
            this.playReadyEncryptorAudio.init(playReadyKeyInfo);
            this.playReadyEncryptorVideo = new PlayReadyEncryptor();
            this.playReadyEncryptorVideo.init(playReadyKeyInfo);
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerSmoothStreaming.init[" + this.contextStr + "]: PlayReady encrypted " + PlayReadyUtils.algorithmIdToString((int)playReadyKeyInfo.getAlgorithmId()) + ": keyId: " + playReadyKeyInfo.getKeyIdAsString());
        }
    }

    protected void addVideoEntry(String string, HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry) {
        this.videoEntries.put(string, hTTPStreamerSmoothStreamerIndexEntry);
        hTTPStreamerSmoothStreamerIndexEntry.setStreamerIndex(this);
        hTTPStreamerSmoothStreamerIndexEntry.setVideo(true);
        this.videoOrder.add(string);
        if (this.primaryVideo == null) {
            this.primaryVideo = string;
        }
    }

    protected void addAudioEntry(String string, HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry) {
        this.audioEntries.put(string, hTTPStreamerSmoothStreamerIndexEntry);
        hTTPStreamerSmoothStreamerIndexEntry.setStreamerIndex(this);
        hTTPStreamerSmoothStreamerIndexEntry.setAudio(true);
        if (this.primaryAudio == null) {
            this.primaryAudio = string;
        }
    }

    @Override
    public void indexFile() {
        block11: {
            HashMap<String, HTTPStreamerSmoothStreamerIndexEntry> hashMap;
            int n = this.audioEntries.size();
            int n2 = this.videoEntries.size();
            if (n == 0 && n2 == 0) break block11;
            HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry = null;
            if (this.primaryAudio != null) {
                hTTPStreamerSmoothStreamerIndexEntry = this.audioEntries.get(this.primaryAudio);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.videoEntries.keySet()) {
                hashMap = this.videoEntries.get(string);
                this.indexEntry((HTTPStreamerSmoothStreamerIndexEntry)((Object)hashMap));
                if (((HTTPStreamerSmoothStreamerIndexEntry)((Object)hashMap)).isVideo()) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                for (String string : arrayList) {
                    this.videoEntries.remove(string);
                }
                this.primaryVideo = null;
                for (String string : this.videoOrder) {
                    if (!this.videoEntries.containsKey(string)) continue;
                    this.primaryVideo = string;
                    break;
                }
            }
            boolean bl = ((HTTPStreamerApplicationContextSmoothStreamer)this.appContext).isSmoothStreamingUseSMILBitrates();
            if (hTTPStreamerSmoothStreamerIndexEntry != null) {
                int n3;
                hashMap = new HashMap();
                this.primaryAudio = null;
                this.indexEntry(hTTPStreamerSmoothStreamerIndexEntry);
                if (hTTPStreamerSmoothStreamerIndexEntry.isAudio() && (n3 = hTTPStreamerSmoothStreamerIndexEntry.getMediaInfoAudio().getAudioBitrate()) > 0) {
                    String string = n3 + "";
                    if (bl && hTTPStreamerSmoothStreamerIndexEntry.getPlaylistBitrate() != null) {
                        string = hTTPStreamerSmoothStreamerIndexEntry.getPlaylistBitrate();
                    }
                    hashMap.put(string, hTTPStreamerSmoothStreamerIndexEntry);
                    if (this.primaryAudio == null) {
                        this.primaryAudio = string;
                    }
                }
                this.audioEntries = hashMap;
            }
            hashMap = new HashMap<String, HTTPStreamerSmoothStreamerIndexEntry>();
            this.primaryVideo = null;
            for (String string : this.videoOrder) {
                int n4;
                HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry2 = this.videoEntries.get(string);
                if (hTTPStreamerSmoothStreamerIndexEntry2 == null || (n4 = hTTPStreamerSmoothStreamerIndexEntry2.getMediaInfoVideo().getVideoBitrate()) <= 0) continue;
                String string2 = n4 + "";
                if (bl && hTTPStreamerSmoothStreamerIndexEntry2.getPlaylistBitrate() != null) {
                    string2 = hTTPStreamerSmoothStreamerIndexEntry2.getPlaylistBitrate();
                }
                hashMap.put(string2, hTTPStreamerSmoothStreamerIndexEntry2);
                if (this.primaryVideo != null) continue;
                this.primaryVideo = string2;
            }
            this.videoEntries = hashMap;
            this.setIndexes();
        }
    }

    private void setIndexes() {
        HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry;
        String string;
        Iterator<String> iterator = null;
        int n = 0;
        iterator = this.videoEntries.keySet().iterator();
        n = 0;
        while (iterator.hasNext()) {
            string = iterator.next();
            hTTPStreamerSmoothStreamerIndexEntry = this.videoEntries.get(string);
            hTTPStreamerSmoothStreamerIndexEntry.setIndex(n);
            ++n;
        }
        iterator = this.audioEntries.keySet().iterator();
        n = 0;
        while (iterator.hasNext()) {
            string = iterator.next();
            hTTPStreamerSmoothStreamerIndexEntry = this.audioEntries.get(string);
            hTTPStreamerSmoothStreamerIndexEntry.setIndex(n);
            ++n;
        }
    }

    protected boolean indexEntry(HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry) {
        hTTPStreamerSmoothStreamerIndexEntry.open(this.httpStreamerSession, this.appInstance, this.smoothStreamingMediaMajorVersion, this.smoothStreamingMediaMinorVersion);
        return hTTPStreamerSmoothStreamerIndexEntry.isOpen();
    }

    public Set<HTTPStreamerSmoothStreamerIndexEntry> getAllEntries() {
        HashSet<HTTPStreamerSmoothStreamerIndexEntry> hashSet = new HashSet<HTTPStreamerSmoothStreamerIndexEntry>();
        hashSet.addAll(this.videoEntries.values());
        hashSet.addAll(this.audioEntries.values());
        return hashSet;
    }

    @Override
    public void close() {
        Set<HTTPStreamerSmoothStreamerIndexEntry> set = this.getAllEntries();
        for (HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry : set) {
            try {
                hTTPStreamerSmoothStreamerIndexEntry.close();
            }
            catch (Exception exception) {}
        }
        set.clear();
    }

    @Override
    public void open() {
    }

    @Override
    public String getPlaylistStr() {
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry = null;
        HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry2 = null;
        SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = null;
        SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = null;
        PlayReadyMediaInfo playReadyMediaInfo = null;
        long l = 0L;
        if (this.videoEntries.size() > 0) {
            hTTPStreamerSmoothStreamerIndexEntry = this.videoEntries.get(this.primaryVideo);
            if (hTTPStreamerSmoothStreamerIndexEntry.getPlayReadyMediaInfo() != null) {
                playReadyMediaInfo = hTTPStreamerSmoothStreamerIndexEntry.getPlayReadyMediaInfo();
            }
            if ((smoothStreamingMediaInfoVideo = hTTPStreamerSmoothStreamerIndexEntry.getMediaInfoVideo()).getVideoTrackDuration() > l) {
                l = smoothStreamingMediaInfoVideo.getVideoTrackDuration();
            }
        }
        if (this.audioEntries.size() > 0) {
            hTTPStreamerSmoothStreamerIndexEntry2 = this.audioEntries.get(this.primaryAudio);
            if (hTTPStreamerSmoothStreamerIndexEntry2.getPlayReadyMediaInfo() != null) {
                playReadyMediaInfo = hTTPStreamerSmoothStreamerIndexEntry2.getPlayReadyMediaInfo();
            }
            if ((smoothStreamingMediaInfoAudio = hTTPStreamerSmoothStreamerIndexEntry2.getMediaInfoAudio()).getAudioTrackDuration() > l) {
                l = smoothStreamingMediaInfoAudio.getAudioTrackDuration();
            }
        }
        stringBuffer.append("<SmoothStreamingMedia MajorVersion=\"" + this.smoothStreamingMediaMajorVersion + "\" MinorVersion=\"" + this.smoothStreamingMediaMinorVersion + "\" Timescale=\"10000000\" Duration=\"" + l + "\">" + "\n");
        if (hTTPStreamerSmoothStreamerIndexEntry2 != null) {
            if (this.smoothStreamingMediaMajorVersion >= 2) {
                stringBuffer.append("<StreamIndex Type=\"audio\" Index=\"0\" Chunks=\"" + hTTPStreamerSmoothStreamerIndexEntry2.getAudioFrags().size() + "\" QualityLevels=\"" + this.audioEntries.size() + "\" Timescale=\"10000000\" Url=\"QualityLevels({bitrate})/Fragments(audio={start time})/Chunks({chunk id})/WowzaSessions(" + "{sessionid}" + ").isma\">" + "\n");
            } else {
                stringBuffer.append("<StreamIndex Type=\"audio\" Subtype=\"WmaPro\" Chunks=\"" + hTTPStreamerSmoothStreamerIndexEntry2.getAudioFrags().size() + "\" Url=\"QualityLevels({bitrate})/Fragments(audio={start time})/Chunks({chunk id})/WowzaSessions(" + "{sessionid}" + ").isma\">" + "\n");
            }
            for (String list2 : this.audioEntries.keySet()) {
                String l3;
                HTTPStreamerSmoothStreamerIndexEntry string3 = this.audioEntries.get(list2);
                SmoothStreamingMediaInfoAudio n4 = string3.getMediaInfoAudio();
                String string = list2;
                String string2 = "";
                if (n4.getAudioWaveFormatEx() != null) {
                    l3 = this.smoothStreamingMediaMajorVersion >= 2 ? "CodecPrivateData" : "WaveFormatEx";
                    string2 = " " + l3 + "=\"" + BufferUtils.encodeHexString((byte[])n4.getAudioWaveFormatEx()) + "\"";
                }
                if (this.smoothStreamingMediaMajorVersion >= 2) {
                    l3 = n4.getAudioFourCC();
                    stringBuffer.append("<QualityLevel Bitrate=\"" + string + "\" FourCC=\"" + l3 + "\" SamplingRate=\"" + n4.getAudioSamplingRate() + "\" Channels=\"" + n4.getAudioChannels() + "\" BitsPerSample=\"" + n4.getAudioBitsPerSample() + "\" PacketSize=\"" + n4.getAudioPacketSize() + "\" AudioTag=\"" + n4.getAudioTag() + "\"" + string2 + " />" + "\n");
                    continue;
                }
                stringBuffer.append("<QualityLevel Bitrate=\"" + string + "\"" + string2 + " />" + "\n");
            }
            List<SmoothStreamerIndexBaseFrag> n3 = hTTPStreamerSmoothStreamerIndexEntry2.getAudioFrags();
            n = n3.size();
            if (n > 0) {
                long byArray = n3.get((int)0).timecode;
                for (int iterator = 0; iterator < n; ++iterator) {
                    long n7 = 0L;
                    if (iterator >= n - 1) {
                        n7 = smoothStreamingMediaInfoAudio.getAudioTrackDuration() - byArray;
                        if (n7 < 0L) {
                            n7 = 0L;
                        }
                    } else {
                        object2 = n3.get(iterator + 1);
                        n7 = ((SmoothStreamerIndexBaseFrag)object2).timecode - byArray;
                        byArray = ((SmoothStreamerIndexBaseFrag)object2).timecode;
                    }
                    stringBuffer.append("<c d=\"" + n7 + "\" />" + "\n");
                }
            }
            stringBuffer.append("</StreamIndex>\n");
        }
        if (hTTPStreamerSmoothStreamerIndexEntry != null) {
            int byArray;
            List<SmoothStreamerIndexBaseFrag> list;
            int n2 = 0;
            boolean string = false;
            n = 0;
            int n3 = 0;
            int n4 = 0;
            for (String string3 : this.videoEntries.keySet()) {
                list = this.videoEntries.get(string3);
                object2 = ((HTTPStreamerSmoothStreamerIndexEntry)((Object)list)).getMediaInfoVideo();
                int l4 = ((SmoothStreamingMediaInfoVideo)object2).getVideoWidth() * ((SmoothStreamingMediaInfoVideo)object2).getVideoHeight();
                if (l4 <= n2) continue;
                n2 = l4;
                byArray = ((SmoothStreamingMediaInfoVideo)object2).getVideoWidth();
                n = ((SmoothStreamingMediaInfoVideo)object2).getVideoHeight();
                n3 = ((SmoothStreamingMediaInfoVideo)object2).getDisplayWidth();
                n4 = ((SmoothStreamingMediaInfoVideo)object2).getDisplayHeight();
            }
            if (this.smoothStreamingMediaMajorVersion >= 2) {
                stringBuffer.append("<StreamIndex Type=\"video\" Chunks=\"" + hTTPStreamerSmoothStreamerIndexEntry.getVideoFrags().size() + "\" QualityLevels=\"" + this.videoEntries.size() + "\" MaxWidth=\"" + byArray + "\" MaxHeight=\"" + n + "\" DisplayWidth=\"" + n3 + "\" DisplayHeight=\"" + n4 + "\" Timescale=\"10000000\" Url=\"QualityLevels({bitrate})/Fragments(video={start time})/Chunks({chunk id})/WowzaSessions(" + "{sessionid}" + ").ismv\">" + "\n");
            } else {
                stringBuffer.append("<StreamIndex Type=\"video\" Subtype=\"" + smoothStreamingMediaInfoVideo.getVideoFourCC() + "\" Chunks=\"" + hTTPStreamerSmoothStreamerIndexEntry.getVideoFrags().size() + "\" Url=\"QualityLevels({bitrate})/Fragments(video={start time})/Chunks({chunk id})/WowzaSessions(" + "{sessionid}" + ").ismv\">" + "\n");
            }
            Iterator<String> iterator = this.videoEntries.keySet().iterator();
            int n5 = 0;
            while (iterator.hasNext()) {
                list = iterator.next();
                object2 = this.videoEntries.get(list);
                SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo2 = ((HTTPStreamerSmoothStreamerIndexEntry)object2).getMediaInfoVideo();
                List<SmoothStreamerIndexBaseFrag> list2 = list;
                String string4 = "";
                if (smoothStreamingMediaInfoVideo2.getVideoCodecPrivateData() != null) {
                    string4 = " CodecPrivateData=\"" + BufferUtils.encodeHexString((byte[])smoothStreamingMediaInfoVideo2.getVideoCodecPrivateData()) + "\"";
                }
                if (this.smoothStreamingMediaMajorVersion >= 2) {
                    stringBuffer.append("<QualityLevel Index=\"" + n5 + "\" Bitrate=\"" + (String)((Object)list2) + "\" FourCC=\"" + smoothStreamingMediaInfoVideo2.getVideoFourCC() + "\" MaxWidth=\"" + smoothStreamingMediaInfoVideo2.getVideoWidth() + "\" MaxHeight=\"" + smoothStreamingMediaInfoVideo2.getVideoHeight() + "\"" + string4 + " />" + "\n");
                } else {
                    stringBuffer.append("<QualityLevel Bitrate=\"" + (String)((Object)list2) + "\" FourCC=\"" + smoothStreamingMediaInfoVideo.getVideoFourCC() + "\" Width=\"" + smoothStreamingMediaInfoVideo2.getVideoWidth() + "\" Height=\"" + smoothStreamingMediaInfoVideo2.getVideoHeight() + "\"" + string4 + " />" + "\n");
                }
                ++n5;
            }
            list = hTTPStreamerSmoothStreamerIndexEntry.getVideoFrags();
            int n6 = list.size();
            if (n6 > 0) {
                long l2 = ((SmoothStreamerIndexBaseFrag)list.get((int)0)).timecode;
                for (int i = 0; i < n6; ++i) {
                    long l3 = 0L;
                    if (i >= n6 - 1) {
                        l3 = smoothStreamingMediaInfoVideo.getVideoTrackDuration() - l2;
                        if (l3 < 0L) {
                            l3 = 0L;
                        }
                    } else {
                        SmoothStreamerIndexBaseFrag smoothStreamerIndexBaseFrag = (SmoothStreamerIndexBaseFrag)list.get(i + 1);
                        l3 = smoothStreamerIndexBaseFrag.timecode - l2;
                        l2 = smoothStreamerIndexBaseFrag.timecode;
                    }
                    stringBuffer.append("<c d=\"" + l3 + "\" />" + "\n");
                }
            }
            stringBuffer.append("</StreamIndex>\n");
        }
        if (playReadyMediaInfo != null) {
            object = "";
            String string = playReadyMediaInfo.getSystemIdAsString();
            if (string != null) {
                object = " SystemID=\"" + string + "\"";
            }
            String string5 = "";
            byte[] byArray = playReadyMediaInfo.getExtraData();
            if (byArray != null) {
                string5 = Base64.encodeBytes((byte[])byArray, (int)8);
            }
            stringBuffer.append("<Protection>\n");
            stringBuffer.append("<ProtectionHeader" + (String)object + ">" + string5 + "</ProtectionHeader>" + "\n");
            stringBuffer.append("</Protection>\n");
        } else if (this.playReadyKeyInfo != null) {
            object = "";
            byte[] byArray = this.playReadyKeyInfo.getProtectionHeaderBytes();
            if (byArray != null) {
                object = Base64.encodeBytes((byte[])byArray, (int)8);
            }
            stringBuffer.append("<Protection>\n");
            stringBuffer.append("<ProtectionHeader SystemID=\"9A04F079-9840-4286-AB92-E65BE0885F95\">" + (String)object + "</ProtectionHeader>" + "\n");
            stringBuffer.append("</Protection>\n");
        }
        stringBuffer.append("</SmoothStreamingMedia>\n");
        return stringBuffer.toString();
    }

    @Override
    public String getTitleStr() {
        return this.titleStr;
    }

    @Override
    public void setTitleStr(String string) {
        this.titleStr = string;
    }

    @Override
    public RTPPacketFragmentList getFragment(int n, int n2, long l, boolean bl) {
        RTPPacketFragmentList rTPPacketFragmentList = null;
        HTTPStreamerSmoothStreamerIndexEntry hTTPStreamerSmoothStreamerIndexEntry = null;
        if (n == 8) {
            hTTPStreamerSmoothStreamerIndexEntry = this.audioEntries.get(n2 + "");
            if (hTTPStreamerSmoothStreamerIndexEntry != null) {
                rTPPacketFragmentList = hTTPStreamerSmoothStreamerIndexEntry.getAudioFragment(l, bl);
            }
        } else if (n == 9 && (hTTPStreamerSmoothStreamerIndexEntry = this.videoEntries.get(n2 + "")) != null) {
            rTPPacketFragmentList = hTTPStreamerSmoothStreamerIndexEntry.getVideoFragment(l, bl);
        }
        return rTPPacketFragmentList;
    }

    @Override
    public IHTTPStreamerSession getHttpStreamerSession() {
        return this.httpStreamerSession;
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public PlayReadyKeyInfo getPlayReadyKeyInfo() {
        return this.playReadyKeyInfo;
    }

    @Override
    public PlayReadyEncryptor getPlayReadyEncryptorAudio() {
        return this.playReadyEncryptorAudio;
    }

    @Override
    public PlayReadyEncryptor getPlayReadyEncryptorVideo() {
        return this.playReadyEncryptorVideo;
    }
}

