/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer;

import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.HTTPCrossdomainHandler;
import com.wowza.wms.http.HTTPRequestAdapter;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerAdapterBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerRequest;
import com.wowza.wms.httpstreamer.model.HTTPStreamerResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerApplicationContextSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.SmoothStreamerFragmentId;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.SmoothStreamingURL;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylist;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylistEntry;
import com.wowza.wms.httpstreamer.smoothstreaming.util.LiveStreamPacketizerSmoothStreamerUtils;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoSession;

public class HTTPStreamerAdapterSmoothStreamer
extends HTTPStreamerAdapterBase {
    public static boolean doDebug = false;
    public static final int CLIENTACCESSPOLICY_READ_FREQUENCY = 5000;
    protected String clientAccessPolicyPath = "${com.wowza.wms.context.VHostConfigHome}/conf/clientaccesspolicy.xml";
    protected boolean clientAccessPolicyResolved = false;
    protected long lastClientAccessPolicyRead = -1L;
    protected String clientAccessPolicyStr = null;
    protected boolean debugLog = false;
    protected int requestTimeout = 12000;
    protected int tcpTimeToLive = 500;
    protected int tcpKeepAliveTimeout = 5000;
    private Map<String, DebugSession> debugRequests = null;
    private DebugThread debugThread = null;

    public HTTPStreamerAdapterSmoothStreamer() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
        if (this.debugRequests != null) {
            this.debugThread.start();
        }
    }

    public void init() {
        super.init();
        this.clientAccessPolicyPath = this.properties.getPropertyStr("clientAccessPolicyPath", this.clientAccessPolicyPath);
        this.requestTimeout = this.getProperties().getPropertyInt("requestTimeout", this.requestTimeout);
        this.tcpTimeToLive = this.getProperties().getPropertyInt("tcpTimeToLive", this.tcpTimeToLive);
        this.tcpKeepAliveTimeout = this.getProperties().getPropertyInt("tcpKeepAliveTimeout", this.tcpKeepAliveTimeout);
        this.debugLog = WMSLoggerFactory.getLogger(null).isDebugEnabled();
    }

    public boolean canHandle(String string) {
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        boolean bl = super.canHandle(string);
        if (doDebug) {
            WMSLoggerFactory.getLogger(null).info("HTTPStreamerAdapterSmoothStreamer.canHandle[" + string + "]: " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDebugRequests() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dumpDebugRequests:\n");
        Map<String, DebugSession> map = this.debugRequests;
        synchronized (map) {
            for (String string : this.debugRequests.keySet()) {
                DebugSession debugSession = this.debugRequests.get(string);
                if (debugSession == null) continue;
                for (String string2 : debugSession.debugRequests.keySet()) {
                    DebugRequest debugRequest = debugSession.debugRequests.get(string2);
                    stringBuffer.append("  " + string + ":" + string2 + ":" + debugRequest.type + "\n");
                }
            }
        }
        if (stringBuffer.length() > 0) {
            System.out.println(stringBuffer.toString());
        }
    }

    public void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        if (rtmpRequestMessage.getType() == 3) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
            if (rtmpRequestMessage2 != null) {
                this.serviceMsg(l, ioSession, rtmpRequestMessage2, rtmpResponseMessage);
                if (rtmpSessionInfo.isPendingRequest() && l - rtmpRequestMessage2.getCreateTime() > (long)this.requestTimeout) {
                    WMSLoggerFactory.getLogger(null).warn("HTTPStreamerAdapterSmoothStreamer.service: Request timeout: " + this.requestTimeout);
                    rtmpSessionInfo.getAndClearPendingRequest();
                    rtmpResponseMessage.setResponseCode(404);
                }
            } else {
                long l2 = l - ioSession.getLastIoTime();
                long l3 = ioSession.getScheduledWriteBytes();
                boolean bl = false;
                if (l3 <= 0L) {
                    rtmpSessionInfo.setLastBytesToWriteBytes(-1L);
                    if (rtmpSessionInfo.isCloseOnIdle()) {
                        if (l2 >= (long)this.tcpTimeToLive) {
                            ioSession.close();
                        }
                    } else if (l2 >= (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                } else {
                    long l4 = rtmpSessionInfo.getLastBytesToWriteBytes();
                    long l5 = rtmpSessionInfo.getLastBytesToWriteTimecode();
                    if (l4 == -1L || l4 != l3) {
                        rtmpSessionInfo.setLastBytesToWriteBytes(l3);
                        rtmpSessionInfo.setLastBytesToWriteTimecode(l);
                    } else if (l - l5 > (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    Set set = rtmpSessionInfo.getHTTPSession();
                    for (IHTTPStreamerSession iHTTPStreamerSession : set) {
                        iHTTPStreamerSession.touch(l);
                    }
                }
            }
        } else {
            this.serviceMsg(l, ioSession, rtmpRequestMessage, rtmpResponseMessage);
        }
    }

    public void serviceMsg(long l, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string = rtmpRequestMessage.getPath();
            int n = string.indexOf("?");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            HTTPStreamerRequest hTTPStreamerRequest = new HTTPStreamerRequest(rtmpRequestMessage);
            HTTPStreamerResponse hTTPStreamerResponse = new HTTPStreamerResponse(rtmpResponseMessage);
            IVHost iVHost = rtmpRequestMessage.getVHost();
            String string2 = hTTPStreamerRequest.getHeader("connection");
            boolean bl = false;
            if (string2 != null && string2.equalsIgnoreCase("close")) {
                bl = true;
            }
            rtmpSessionInfo.setCloseOnIdle(bl);
            if (string.endsWith("Manifest")) {
                this.onManifest(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".ismv") || string.endsWith(".isma")) {
                this.onISMVData(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith("clientaccesspolicy.xml")) {
                this.onClientAccessPolicy(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPRequestAdapter.class).error("HTTPStreamerAdapterSmoothStreaming.service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public File getClientAccessPolicyFile() {
        if (!this.clientAccessPolicyResolved && this.vhost != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", this.vhost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.vhost.getHomePath());
            this.clientAccessPolicyPath = SystemUtils.expandEnvironmentVariables((String)this.clientAccessPolicyPath, hashMap);
            this.clientAccessPolicyResolved = true;
        }
        return new File(this.clientAccessPolicyPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientAccessPolicy(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        block23: {
            try {
                Object object;
                Closeable closeable;
                File file;
                if ((this.clientAccessPolicyStr == null || l - this.lastClientAccessPolicyRead > 5000L) && (file = this.getClientAccessPolicyFile()).exists()) {
                    closeable = null;
                    try {
                        object = new StringBuffer();
                        closeable = new BufferedReader(new FileReader(file));
                        String string = null;
                        while ((string = ((BufferedReader)closeable).readLine()) != null) {
                            ((StringBuffer)object).append(string + "\n");
                        }
                        this.clientAccessPolicyStr = ((StringBuffer)object).toString();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (closeable != null) {
                            try {
                                ((BufferedReader)closeable).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.lastClientAccessPolicyRead = l;
                }
                boolean bl = true;
                if (this.clientAccessPolicyStr == null) {
                    bl = false;
                } else if (this.clientAccessPolicyStr.length() == 0) {
                    bl = false;
                }
                try {
                    if (bl) {
                        iHTTPResponse.setHeader("Content-Type", "text/xml");
                        closeable = iHTTPResponse.getOutputStream();
                        object = this.clientAccessPolicyStr.getBytes();
                        ((OutputStream)closeable).write((byte[])object);
                        break block23;
                    }
                    iHTTPResponse.setResponseCode(404);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPCrossdomainHandler.class).error("HTTPCrossdomainHandler.onClientAccessPolicy: " + exception.toString());
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPRequestAdapter.class).error("HTTPStreamerAdapterSmoothStreaming.onClientAccessPolicy: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPRequest iHTTPRequest, IApplicationInstance iApplicationInstance, String string, String string2) {
        int n;
        int n2;
        HTTPStreamerSessionSmoothStreamer hTTPStreamerSessionSmoothStreamer = new HTTPStreamerSessionSmoothStreamer();
        String string3 = iHTTPRequest.getHeader("referrer");
        hTTPStreamerSessionSmoothStreamer.setReferrer(string3);
        String string4 = iHTTPRequest.getHeader("host");
        int n3 = 80;
        if (string4 != null && (n2 = string4.indexOf(":")) >= 0) {
            try {
                n3 = Integer.parseInt(string4.substring(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string4.substring(0, n2);
        }
        hTTPStreamerSessionSmoothStreamer.setServerIp(string4);
        hTTPStreamerSessionSmoothStreamer.setServerPort(n3);
        String string5 = iHTTPRequest.getHeader("context");
        String string6 = null;
        if (string5 != null && (n = (string5 = HTTPStreamerUtils.urlDecode((String)string5)).indexOf("?")) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        hTTPStreamerSessionSmoothStreamer.setUri(string5);
        hTTPStreamerSessionSmoothStreamer.setQueryStr(string6);
        hTTPStreamerSessionSmoothStreamer.setUserAgent(iHTTPRequest.getHeader("user-agent"));
        hTTPStreamerSessionSmoothStreamer.setCookieStr(iHTTPRequest.getHeader("cookie"));
        hTTPStreamerSessionSmoothStreamer.addStreamDomainStr(string2);
        this.createSession((IHTTPStreamerSession)hTTPStreamerSessionSmoothStreamer, iApplicationInstance, string);
        return hTTPStreamerSessionSmoothStreamer;
    }

    public void onManifest(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block55: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                String charSequence;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                boolean bl3;
                int n;
                MediaStreamMap mediaStreamMap;
                SmoothStreamingURL smoothStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block55;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (doDebug) {
                    System.out.println("onManifest: " + string);
                }
                if ((smoothStreamingURL = new SmoothStreamingURL(string, true)) == null) break block55;
                String string2 = smoothStreamingURL.getAppName();
                String string3 = smoothStreamingURL.getAppInstanceName();
                String string4 = smoothStreamingURL.getStreamName();
                String string5 = smoothStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onManifest: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block55;
                }
                HTTPStreamerApplicationContextSmoothStreamer hTTPStreamerApplicationContextSmoothStreamer = iHTTPStreamerApplicationContext instanceof HTTPStreamerApplicationContextSmoothStreamer ? (HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext : null;
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl4 = this.isLive(iApplicationInstance);
                boolean bl5 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(null, iApplicationInstance, bl5, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block55;
                ILiveStreamPacketizer iLiveStreamPacketizer = null;
                SmoothStreamingLivePlaylist smoothStreamingLivePlaylist = null;
                boolean bl6 = false;
                if (bl4) {
                    mediaStreamMap = iApplicationInstance.getStreams();
                    bl6 = hTTPStreamerStreamNameParts.streamExt.equals("smil");
                    int n2 = n = hTTPStreamerApplicationContextSmoothStreamer != null ? hTTPStreamerApplicationContextSmoothStreamer.getMinPlaylistStartDuration() : 20000;
                    if (bl6) {
                        smoothStreamingLivePlaylist = LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt);
                        if (smoothStreamingLivePlaylist == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: Playlist cound not be parsed: " + string);
                            break block55;
                        }
                        bl3 = false;
                        object4 = smoothStreamingLivePlaylist.getBitrates();
                        Iterator<String> iterator = object4.iterator();
                        while (iterator.hasNext()) {
                            object3 = iterator.next();
                            object2 = smoothStreamingLivePlaylist.get((String)object3);
                            object = this.resolveStreamName(null, iApplicationInstance, bl5, ((SmoothStreamingLivePlaylistEntry)object2).getStreamName());
                            if (object.resolvedName == null) break;
                            if (bl5) {
                                this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, object.repeaterName);
                            }
                            if ((charSequence = mediaStreamMap.getLiveStreamPacketizer(object.resolvedName, this.liveStreamPacketizer, false)) == null) {
                                if (bl5) {
                                    bl = true;
                                } else {
                                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer not found [" + object.resolvedName + "]: " + this.liveStreamPacketizer);
                                }
                                bl3 = true;
                                continue;
                            }
                            if (((LiveStreamPacketizerSmoothStreaming)((Object)charSequence)).testPlaylistDuration(n)) continue;
                            bl = true;
                            bl3 = true;
                        }
                        if (bl3) {
                            break block55;
                        }
                    } else {
                        if (hTTPStreamerStreamNameParts.resolvedName == null) break block55;
                        if (bl5) {
                            this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                        }
                        if ((iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                            if (bl5) {
                                bl = true;
                            } else {
                                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer not found [" + string + "]: " + this.liveStreamPacketizer);
                            }
                            break block55;
                        }
                        if (!((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).testPlaylistDuration(n)) {
                            bl = true;
                            break block55;
                        }
                    }
                }
                mediaStreamMap = null;
                n = 0;
                if (mediaStreamMap == null) {
                    n = 1;
                    mediaStreamMap = this.createSession(iHTTPRequest, iApplicationInstance, null, string6);
                }
                if (n != 0) {
                    mediaStreamMap.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    mediaStreamMap.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                if (mediaStreamMap == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onManifest: Should not get here [" + string + "]: " + string2 + "/" + string3);
                    break block55;
                }
                rtmpSessionInfo.addHTTPSession((IHTTPStreamerSession)mediaStreamMap);
                if (!mediaStreamMap.isValidated()) {
                    mediaStreamMap.setLiveStreamingPacketizer(this.liveStreamPacketizer);
                    this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "smoothstreaming", (IHTTPStreamerSession)mediaStreamMap, iHTTPRequest.getRemoteAddr());
                    mediaStreamMap.setSessionType(bl4 ? 1 : 2);
                }
                if (n != 0) {
                    this.notifySessionCreate((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance);
                }
                if (!mediaStreamMap.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block55;
                }
                if (!mediaStreamMap.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block55;
                }
                mediaStreamMap.touch(l);
                if (bl6) {
                    ((HTTPStreamerSessionSmoothStreamer)mediaStreamMap).setLivePlaylist(smoothStreamingLivePlaylist);
                }
                if (!(bl3 = mediaStreamMap.isActive())) break block55;
                object4 = "";
                boolean bl7 = true;
                if (!bl4) {
                    object3 = ((HTTPStreamerSessionSmoothStreamer)mediaStreamMap).getIndex((IHTTPStreamerSession)mediaStreamMap, iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object3 == null) break block55;
                    object2 = object3.getStreamNames();
                    mediaStreamMap.addStreamDomainStrs((List)object2);
                    object4 = object3.getPlaylistStr();
                } else if (bl4) {
                    if (bl6) {
                        if (smoothStreamingLivePlaylist != null) {
                            String string7;
                            LiveStreamPacketizerSmoothStreaming liveStreamPacketizerSmoothStreaming;
                            ILiveStreamPacketizer iLiveStreamPacketizer2;
                            HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts2;
                            SmoothStreamingLivePlaylistEntry smoothStreamingLivePlaylistEntry;
                            object3 = "";
                            boolean bl8 = false;
                            object = "";
                            charSequence = "";
                            String string72 = "";
                            boolean bl9 = false;
                            boolean bl10 = false;
                            boolean bl11 = false;
                            String string8 = "";
                            String string9 = "";
                            String string10 = "";
                            String string11 = "";
                            String string12 = "";
                            MediaStreamMap mediaStreamMap2 = iApplicationInstance.getStreams();
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            boolean bl12 = true;
                            boolean bl13 = ((HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext).isSmoothStreamingUseSMILBitrates();
                            String string13 = null;
                            String string14 = smoothStreamingLivePlaylist.getAudioStreamName();
                            String string15 = null;
                            List<String> list = smoothStreamingLivePlaylist.getBitrates();
                            for (String charSequence32 : list) {
                                smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(charSequence32);
                                hTTPStreamerStreamNameParts2 = this.resolveStreamName((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance, bl5, smoothStreamingLivePlaylistEntry.getStreamName());
                                if (hTTPStreamerStreamNameParts2.resolvedName == null) break;
                                iLiveStreamPacketizer2 = mediaStreamMap2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts2.resolvedName, this.liveStreamPacketizer, false);
                                if (iLiveStreamPacketizer2 == null) continue;
                                liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer2;
                                if (string15 == null) {
                                    string15 = hTTPStreamerStreamNameParts2.resolvedName;
                                }
                                if (hTTPStreamerStreamNameParts2.resolvedName.equals(string14)) {
                                    string13 = hTTPStreamerStreamNameParts2.resolvedName;
                                }
                                String string16 = string7 = bl13 ? charSequence32 : liveStreamPacketizerSmoothStreaming.getVideoBitrate() + "";
                                if (!hashMap.containsKey(string7)) {
                                    hashMap.put(charSequence32, string7);
                                    continue;
                                }
                                bl12 = false;
                            }
                            if (bl12) {
                                smoothStreamingLivePlaylist.remapBitrates(hashMap);
                            }
                            if (string13 == null) {
                                string13 = string15;
                            }
                            list = smoothStreamingLivePlaylist.getBitrates();
                            for (String string17 : list) {
                                smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(string17);
                                hTTPStreamerStreamNameParts2 = this.resolveStreamName((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance, bl5, smoothStreamingLivePlaylistEntry.getStreamName());
                                if (hTTPStreamerStreamNameParts2.resolvedName == null) break;
                                iLiveStreamPacketizer2 = mediaStreamMap2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts2.resolvedName, this.liveStreamPacketizer, false);
                                if (iLiveStreamPacketizer2 == null) continue;
                                liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer2;
                                string7 = liveStreamPacketizerSmoothStreaming.getXMLQualityLevelVideo();
                                string7 = string7.replace("{videobitrate}", string17);
                                if (hTTPStreamerStreamNameParts2.resolvedName.equals(string13)) {
                                    bl8 = liveStreamPacketizerSmoothStreaming.isXMLIsVideo();
                                    bl9 = liveStreamPacketizerSmoothStreaming.isXMLIsAudio();
                                    bl10 = liveStreamPacketizerSmoothStreaming.isXMLIsData();
                                    bl11 = liveStreamPacketizerSmoothStreaming.isXMLIsProtection();
                                    String string18 = liveStreamPacketizerSmoothStreaming.getXMLQualityLevelAudio();
                                    int n3 = liveStreamPacketizerSmoothStreaming.getAudioBitrate();
                                    String string19 = n3 + "";
                                    if (bl13 && smoothStreamingLivePlaylist.getAudioBitrate() != null) {
                                        string19 = smoothStreamingLivePlaylist.getAudioBitrate();
                                    }
                                    string18 = string18.replace("{audiobitrate}", string19);
                                    object3 = liveStreamPacketizerSmoothStreaming.getXMLSmoothStreamingMedia();
                                    object = liveStreamPacketizerSmoothStreaming.getXMLStreamIndexVideo();
                                    charSequence = string7;
                                    string72 = liveStreamPacketizerSmoothStreaming.getXMLSamplesVideo();
                                    string8 = liveStreamPacketizerSmoothStreaming.getXMLStreamIndexAudio();
                                    string9 = string18;
                                    string10 = liveStreamPacketizerSmoothStreaming.getXMLSamplesAudio();
                                    string11 = liveStreamPacketizerSmoothStreaming.getXMLData();
                                    string12 = liveStreamPacketizerSmoothStreaming.getXMLProtection();
                                    continue;
                                }
                                charSequence = charSequence + string7;
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                            stringBuffer.append((String)object3);
                            if (bl9) {
                                stringBuffer.append(string8);
                                stringBuffer.append(string9);
                                stringBuffer.append(string10);
                                stringBuffer.append("</StreamIndex>\n");
                            }
                            if (bl8) {
                                stringBuffer.append((String)object);
                                stringBuffer.append(charSequence);
                                stringBuffer.append(string72);
                                stringBuffer.append("</StreamIndex>\n");
                            }
                            if (bl10) {
                                stringBuffer.append(string11);
                            }
                            if (bl11) {
                                stringBuffer.append(string12);
                            }
                            stringBuffer.append("</SmoothStreamingMedia>\n");
                            object4 = stringBuffer.toString();
                        }
                        if (mediaStreamMap != null) {
                            object3 = smoothStreamingLivePlaylist.getStreamNames();
                            mediaStreamMap.addStreamDomainStrs(object3);
                            if (bl5) {
                                mediaStreamMap.lockRepeaterStreams(object3, this.liveStreamPacketizer, this.liveStreamRepeater, iHTTPStreamerApplicationContext.getStreamTypeStr());
                            }
                        }
                    } else {
                        if (iLiveStreamPacketizer == null) break block55;
                        object4 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getXMLISMC();
                        int n4 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getVideoBitrate();
                        int n5 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getAudioBitrate();
                        object4 = ((String)object4).replace("{videobitrate}", n4 + "");
                        object4 = ((String)object4).replace("{audiobitrate}", n5 + "");
                    }
                }
                mediaStreamMap.touch(l);
                if (bl7) {
                    object4 = ((String)object4).replace("{sessionid}", mediaStreamMap.getSessionId());
                }
                if (doDebug) {
                    System.out.println((String)object4);
                }
                iHTTPResponse.setHeader("Content-Type", "text/xml");
                iHTTPResponse.setHeader("Pragma", "no-cache");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                byte[] byArray = ((String)object4).getBytes();
                OutputStream outputStream = iHTTPResponse.getOutputStream();
                outputStream.write(byArray);
                bl2 = true;
                mediaStreamMap.touch(l);
                if (byArray != null && mediaStreamMap != null) {
                    mediaStreamMap.getIOPerformanceCounter().incrementMessagesOut((long)(byArray.length + iHTTPResponse.getHeaderSize()), 1L);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).error("HTTPStreamerAdapterSmoothStreaming.onManifest: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onISMVData(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block47: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                SmoothStreamingURL smoothStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block47;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (doDebug) {
                    System.out.println("onISMVData[" + ioSession.hashCode() + "]: " + string);
                }
                if ((smoothStreamingURL = new SmoothStreamingURL(string, true)) == null) break block47;
                String string2 = smoothStreamingURL.getAppName();
                String string3 = smoothStreamingURL.getAppInstanceName();
                String string4 = smoothStreamingURL.getStreamName();
                String string5 = smoothStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onISMVData: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block47;
                }
                HTTPStreamerApplicationContextSmoothStreamer hTTPStreamerApplicationContextSmoothStreamer = iHTTPStreamerApplicationContext instanceof HTTPStreamerApplicationContextSmoothStreamer ? (HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext : null;
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                boolean bl5 = false;
                SmoothStreamerFragmentId smoothStreamerFragmentId = SmoothStreamerFragmentId.parseURL(string);
                if (smoothStreamerFragmentId == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.getAppInstance: Error decoding fragment name [" + string + "]");
                    break block47;
                }
                DebugSession debugSession = null;
                DebugRequest debugRequest = null;
                if (this.debugRequests != null) {
                    object5 = this.debugRequests;
                    synchronized (object5) {
                        debugSession = this.debugRequests.get(smoothStreamerFragmentId.getSessionId());
                        if (debugSession == null) {
                            debugSession = new DebugSession();
                            debugSession.sessionId = smoothStreamerFragmentId.getSessionId();
                            this.debugRequests.put(debugSession.sessionId, debugSession);
                        }
                        if ((debugRequest = debugSession.debugRequests.get(smoothStreamerFragmentId.getChunkId() + "")) == null) {
                            debugRequest = new DebugRequest();
                            debugRequest.type = smoothStreamerFragmentId.getFragmentType();
                            debugRequest.requestId = smoothStreamerFragmentId.getStartTimecode() + "";
                            debugSession.debugRequests.put(debugRequest.requestId, debugRequest);
                        }
                    }
                }
                object5 = smoothStreamerFragmentId.getSessionId();
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                boolean bl6 = false;
                if (object5 != null && (iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession((String)object5)) == null) {
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, (String)object5, string6);
                    bl6 = true;
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block47;
                if (bl6) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                boolean bl7 = true;
                int n = 0;
                if (iHTTPStreamerSession == null) break block47;
                if (!iHTTPStreamerSession.isValidated()) {
                    this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "smoothstreaming", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                }
                iHTTPStreamerSession.touch(l);
                bl7 = iHTTPStreamerSession.isActive();
                n = iHTTPStreamerSession.getSessionType();
                rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                if (!bl7) break block47;
                if (bl6) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block47;
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block47;
                }
                RTPPacketFragmentList rTPPacketFragmentList = null;
                if (!bl3) {
                    object4 = ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).getIndex(iHTTPStreamerSession, iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object4 == null) break block47;
                    rTPPacketFragmentList = object4.getFragment(smoothStreamerFragmentId.getFragmentType(), smoothStreamerFragmentId.getBitrate(), smoothStreamerFragmentId.getChunkId(), smoothStreamerFragmentId.isInfo());
                    ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).logVODFragment(smoothStreamerFragmentId, rTPPacketFragmentList);
                } else {
                    SmoothStreamingLivePlaylist smoothStreamingLivePlaylist;
                    bl5 = hTTPStreamerStreamNameParts.streamExt.equals("smil");
                    object4 = iApplicationInstance.getStreams();
                    int n2 = hTTPStreamerApplicationContextSmoothStreamer.getKeyFrameAlignmentTolerance();
                    if (bl5) {
                        LiveStreamPacketizerSmoothStreaming liveStreamPacketizerSmoothStreaming;
                        smoothStreamingLivePlaylist = ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).getLivePlaylist();
                        if (smoothStreamingLivePlaylist == null) break block47;
                        if (smoothStreamerFragmentId.getFragmentType() == 8) {
                            object3 = smoothStreamingLivePlaylist.get(0);
                            object2 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, ((SmoothStreamingLivePlaylistEntry)object3).getStreamName());
                            if (((HTTPStreamerStreamNameParts)object2).resolvedName == null || (object = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object2).resolvedName, this.liveStreamPacketizer, false)) == null) break block47;
                            liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)((Object)object);
                            rTPPacketFragmentList = liveStreamPacketizerSmoothStreaming.getAudioPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo());
                        } else if (smoothStreamerFragmentId.getFragmentType() == 9) {
                            object3 = smoothStreamingLivePlaylist.get(smoothStreamerFragmentId.getBitrate() + "");
                            if (object3 == null) {
                                object3 = smoothStreamingLivePlaylist.get(0);
                            }
                            object2 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, ((SmoothStreamingLivePlaylistEntry)object3).getStreamName());
                            if (((HTTPStreamerStreamNameParts)object2).resolvedName == null || (object = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object2).resolvedName, this.liveStreamPacketizer, false)) == null) break block47;
                            liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)((Object)object);
                            rTPPacketFragmentList = liveStreamPacketizerSmoothStreaming.getVideoPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo(), n2);
                            if (rTPPacketFragmentList == null && ((SmoothStreamingLivePlaylistEntry)object3).getIndex() > 0) {
                                object3 = smoothStreamingLivePlaylist.get(0);
                                object2 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, ((SmoothStreamingLivePlaylistEntry)object3).getStreamName());
                                if (((HTTPStreamerStreamNameParts)object2).resolvedName == null || (object = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object2).resolvedName, this.liveStreamPacketizer, false)) == null) break block47;
                                liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)((Object)object);
                                rTPPacketFragmentList = liveStreamPacketizerSmoothStreaming.getVideoPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo(), n2);
                            }
                        }
                    } else {
                        smoothStreamingLivePlaylist = object4.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                        if (smoothStreamingLivePlaylist == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.getAppInstance: LiveStreamPacketizer not found [" + string + "]: " + this.liveStreamPacketizer);
                            break block47;
                        }
                        if (smoothStreamerFragmentId.getFragmentType() == 9) {
                            rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)smoothStreamingLivePlaylist)).getVideoPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo(), n2);
                        } else if (smoothStreamerFragmentId.getFragmentType() == 8) {
                            rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)smoothStreamingLivePlaylist)).getAudioPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo());
                        }
                    }
                    ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).logLiveFragment(smoothStreamerFragmentId, rTPPacketFragmentList);
                }
                if (rTPPacketFragmentList == null) {
                    if (doDebug) {
                        System.out.println("missing[" + string + "]");
                    }
                    bl = true;
                    break block47;
                }
                if (!iHTTPStreamerSession.checkAndSetPlayLogged()) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iHTTPStreamerSession.getStream(), "stream", "play", 200, iHTTPStreamerSession.getStreamName());
                }
                iHTTPResponse.setHeader("Content-Type", "video/mp4");
                iHTTPResponse.setHeader("Pragma", "no-cache");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                object4 = iHTTPResponse.getOutputStream();
                IFasterByteArrayWriteReference iFasterByteArrayWriteReference = null;
                if (object4 instanceof IFasterByteArrayWriteReference) {
                    iFasterByteArrayWriteReference = (IFasterByteArrayWriteReference)object4;
                }
                int n3 = 0;
                object3 = rTPPacketFragmentList.getFragments();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (RTPPacketFragment)object2.next();
                    if (iFasterByteArrayWriteReference != null) {
                        iFasterByteArrayWriteReference.write(object.getBuffer(), object.getOffset(), object.getLen(), true);
                    } else {
                        ((OutputStream)object4).write(object.getBuffer(), object.getOffset(), object.getLen());
                    }
                    n3 += object.getLen();
                }
                if (iHTTPStreamerSession != null) {
                    object = iHTTPStreamerSession.getStream();
                    if (object != null) {
                        object.getMediaIOPerformance().incrementMessagesOut((long)n3, 1L);
                    }
                    iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(n3 + iHTTPResponse.getHeaderSize()), 1L);
                }
                if (doDebug) {
                    System.out.println("sent[" + string + "]: " + n3);
                }
                bl2 = true;
                if (this.debugRequests == null) break block47;
                object = this.debugRequests;
                synchronized (object) {
                    if (debugRequest != null) {
                        debugSession.debugRequests.remove(smoothStreamerFragmentId.getStartTimecode() + "");
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).error("HTTPStreamerAdapterSmoothStreaming.onISMVData: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    class DebugRequest {
        int type = 0;
        String requestId = null;

        DebugRequest() {
        }
    }

    class DebugSession {
        Map<String, DebugRequest> debugRequests = new HashMap<String, DebugRequest>();
        String sessionId = null;

        DebugSession() {
        }
    }

    class DebugThread
    extends Thread {
        DebugThread() {
        }

        public void run() {
            System.out.println("DebugThread.start");
            while (true) {
                try {
                    while (true) {
                        HTTPStreamerAdapterSmoothStreamer.this.dumpDebugRequests();
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    System.out.println("DebugThread: " + exception.toString());
                    continue;
                }
                break;
            }
        }
    }
}

