/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.drm.playready.PlayReadyEncryptor;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.drm.playready.PlayReadyUtils;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragment;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentHeader;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragments;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingPacketHandler;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingPendingFragment;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingRepeaterHolder;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingRepeaterList;
import com.wowza.wms.httpstreamer.smoothstreaming.model.SmoothStreamingDataTracks;
import com.wowza.wms.httpstreamer.smoothstreaming.util.LiveStreamPacketizerSmoothStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerItem;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerSmoothStreaming
extends LiveStreamPacketizerBase {
    public static final int MILLISTOSILVERLIGHT = 10000;
    protected SmoothStreamingFragments videoFragments = new SmoothStreamingFragments(9);
    protected SmoothStreamingFragments audioFragments = new SmoothStreamingFragments(8);
    protected Map<Long, SmoothStreamingPendingFragment> pendingVideoFragments = new HashMap<Long, SmoothStreamingPendingFragment>();
    protected Map<Long, SmoothStreamingPendingFragment> pendingAudioFragments = new HashMap<Long, SmoothStreamingPendingFragment>();
    protected String xmlISMC = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<SmoothStreamingMedia></SmoothStreamingMedia>";
    protected String xmlSmoothStreamingMedia = "";
    protected boolean xmlIsVideo = false;
    protected String xmlStreamIndexVideo = "";
    protected String xmlQualityLevelVideo = "";
    protected String xmlSamplesVideo = "";
    protected boolean xmlIsAudio = false;
    protected String xmlStreamIndexAudio = "";
    protected String xmlQualityLevelAudio = "";
    protected String xmlSamplesAudio = "";
    protected boolean xmlIsData = false;
    protected String xmlData = "";
    protected boolean xmlIsProtection = false;
    protected String xmlProtection = "";
    protected Object ismcXMLLock = new Object();
    protected SmoothStreamingPacketHandler packetHandler = new SmoothStreamingPacketHandler();
    protected int readAheadSize = 2;
    protected int smoothStreamingMediaMajorVersion = 2;
    protected int smoothStreamingMediaMinorVersion = 1;
    protected int smoothBufferTargetDuration = 50000;
    protected int smoothMinimumVideoFragmentDuration = 0;
    protected int smoothBufferMinFragmentCount = 4;
    protected int smoothManifestTargetDuration = 24000;
    protected int smoothManifestMinFragmentCount = 4;
    protected int smoothRepeaterTargetDuration = 24000;
    protected int smoothRepeaterMinFragmentCount = 4;
    protected int smoothPlayReadyH264ClearSize = 5;
    protected int smoothFragmentTargetAudioDuration = 2000;
    protected int smoothFragmentMaximumAudioDuration = 20000;
    protected long nextFragmentIdVideo = 0L;
    protected long nextFragmentIdAudio = 0L;
    protected int maxChunkLogCount = 10;
    protected Object reapeaterItemsLock = new Object();
    protected long repeaterSeq = 0L;
    protected SmoothStreamingRepeaterList repeaterListAudio = null;
    protected SmoothStreamingRepeaterList repeaterListVideo = null;
    protected SmoothStreamingDataTracks dataTracks = new SmoothStreamingDataTracks(this.ismcXMLLock);
    protected PlayReadyKeyInfo playReadyKeyInfo = null;
    protected PlayReadyEncryptor playReadyEncryptorAudio = null;
    protected PlayReadyEncryptor playReadyEncryptorVideo = null;
    protected String contextStr = "";

    public Object getManifestLock() {
        return this.ismcXMLLock;
    }

    public LiveStreamPacketizerSmoothStreaming() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
        this.repeaterListAudio = new SmoothStreamingRepeaterList(this.reapeaterItemsLock, 8);
        this.repeaterListVideo = new SmoothStreamingRepeaterList(this.reapeaterItemsLock, 9);
    }

    public void init(String string, String string2, IApplicationInstance iApplicationInstance, LiveStreamPacketizerItem liveStreamPacketizerItem) {
        super.init(string, string2, iApplicationInstance, liveStreamPacketizerItem);
        this.contextStr = iApplicationInstance.getContextStr() + "/" + string;
        WMSProperties wMSProperties = this.getProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        this.readAheadSize = wMSProperties.getPropertyInt("readAheadSize", this.readAheadSize);
        this.smoothBufferTargetDuration = wMSProperties.getPropertyInt("smoothBufferTargetDuration", this.smoothBufferTargetDuration);
        this.smoothMinimumVideoFragmentDuration = wMSProperties.getPropertyInt("smoothMinimumVideoFragmentDuration", this.smoothMinimumVideoFragmentDuration);
        this.smoothManifestTargetDuration = wMSProperties.getPropertyInt("smoothManifestTargetDuration", this.smoothManifestTargetDuration);
        this.smoothRepeaterTargetDuration = wMSProperties.getPropertyInt("smoothRepeaterTargetDuration", this.smoothRepeaterTargetDuration);
        this.smoothBufferMinFragmentCount = wMSProperties.getPropertyInt("smoothBufferMinFragmentCount", this.smoothBufferMinFragmentCount);
        this.smoothManifestMinFragmentCount = wMSProperties.getPropertyInt("smoothManifestMinFragmentCount", this.smoothManifestMinFragmentCount);
        this.smoothRepeaterMinFragmentCount = wMSProperties.getPropertyInt("smoothRepeaterMinFragmentCount", this.smoothRepeaterMinFragmentCount);
        this.smoothPlayReadyH264ClearSize = wMSProperties.getPropertyInt("smoothPlayReadyH264ClearSize", this.smoothPlayReadyH264ClearSize);
        this.smoothFragmentTargetAudioDuration = wMSProperties.getPropertyInt("smoothFragmentTargetAudioDuration", this.smoothFragmentTargetAudioDuration);
        this.smoothFragmentMaximumAudioDuration = wMSProperties.getPropertyInt("smoothFragmentMaximumAudioDuration", this.smoothFragmentMaximumAudioDuration);
        this.maxChunkLogCount = wMSProperties.getPropertyInt("maxChunkLogCount", this.maxChunkLogCount);
        this.maxChunkLogCount = wMSProperties.getPropertyInt("smoothMaxChunkLogCount", this.maxChunkLogCount);
        this.videoFragments.setSmoothBufferTargetDuration(this.smoothBufferTargetDuration);
        this.videoFragments.setSmoothManifestTargetDuration(this.smoothManifestTargetDuration);
        this.videoFragments.setSmoothBufferMinFragmentCount(this.smoothBufferMinFragmentCount);
        this.videoFragments.setSmoothManifestMinFragmentCount(this.smoothManifestMinFragmentCount);
        this.videoFragments.setContextStr(this.contextStr);
        this.audioFragments.setSmoothBufferTargetDuration(this.smoothBufferTargetDuration);
        this.audioFragments.setSmoothManifestTargetDuration(this.smoothManifestTargetDuration);
        this.audioFragments.setSmoothBufferMinFragmentCount(this.smoothBufferMinFragmentCount);
        this.audioFragments.setSmoothManifestMinFragmentCount(this.smoothManifestMinFragmentCount);
        this.audioFragments.setContextStr(this.contextStr);
        this.smoothStreamingMediaMajorVersion = wMSProperties.getPropertyInt("smoothStreamingMediaMajorVersion", this.smoothStreamingMediaMajorVersion);
        this.smoothStreamingMediaMinorVersion = wMSProperties.getPropertyInt("smoothStreamingMediaMinorVersion", this.smoothStreamingMediaMinorVersion);
        this.smoothStreamingMediaMajorVersion = wMSProperties2.getPropertyInt("smoothStreamingMediaMajorVersion", this.smoothStreamingMediaMajorVersion);
        this.smoothStreamingMediaMinorVersion = wMSProperties2.getPropertyInt("smoothStreamingMediaMinorVersion", this.smoothStreamingMediaMinorVersion);
        PlayReadyKeyInfo playReadyKeyInfo = LiveStreamPacketizerSmoothStreamerUtils.getEncInfo(iApplicationInstance, string);
        if (playReadyKeyInfo == null) {
            playReadyKeyInfo = new PlayReadyKeyInfo();
        }
        iApplicationInstance.getModFunctions().onHTTPSmoothStreamingPlayReadyCreateLive(iApplicationInstance, string, playReadyKeyInfo);
        if (!playReadyKeyInfo.isComplete()) {
            playReadyKeyInfo = null;
        }
        if (playReadyKeyInfo != null) {
            this.setPlayReadKeyInfo(playReadyKeyInfo);
        }
        this.packetHandler.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayReadKeyInfo(PlayReadyKeyInfo playReadyKeyInfo) {
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            this.playReadyKeyInfo = playReadyKeyInfo;
            if (playReadyKeyInfo != null) {
                this.playReadyEncryptorAudio = new PlayReadyEncryptor();
                this.playReadyEncryptorAudio.init(playReadyKeyInfo);
                this.playReadyEncryptorVideo = new PlayReadyEncryptor();
                this.playReadyEncryptorVideo.init(playReadyKeyInfo);
            } else {
                this.playReadyEncryptorAudio = null;
                this.playReadyEncryptorVideo = null;
            }
        }
        if (playReadyKeyInfo != null) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerSmoothStreaming.init[" + this.contextStr + "]: PlayReady encrypted " + PlayReadyUtils.algorithmIdToString((int)playReadyKeyInfo.getAlgorithmId()) + ": keyId: " + playReadyKeyInfo.getKeyIdAsString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayReadyKeyInfo getPlayReadKeyInfo() {
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            return this.playReadyKeyInfo;
        }
    }

    public void internalStartStream(IMediaStream iMediaStream) {
        this.packetHandler.startStream(iMediaStream);
    }

    public void internalResetStream(IMediaStream iMediaStream) {
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.resetStream[" + iMediaStream.getContextStr() + "]");
        this.packetHandler = new SmoothStreamingPacketHandler();
        this.packetHandler.init(this);
        this.clearFragmentAudio();
        this.clearFragmentVideo();
    }

    public void internalHandlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        this.touch(l);
        this.packetHandler.handlePacket(l, iMediaStream, aMFPacket);
    }

    public long getRepeaterAudioLastSeqence() {
        return this.repeaterListAudio.getRepeaterLastSeqence();
    }

    public void getRepeaterAudioItems(List<SmoothStreamingRepeaterHolder> list, long l) {
        this.repeaterListAudio.getRepeaterItems(list, l);
    }

    public long getRepeaterVideoLastSeqence() {
        return this.repeaterListVideo.getRepeaterLastSeqence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRepeaterLastSeqence() {
        long l = -1L;
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            l = this.repeaterSeq;
        }
        return l;
    }

    public void getRepeaterVideoItems(List<SmoothStreamingRepeaterHolder> list, long l) {
        this.repeaterListVideo.getRepeaterItems(list, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepeaterItemAudio(SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder, boolean bl) {
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            this.repeaterListAudio.addRepeaterItem(smoothStreamingRepeaterHolder);
            ++this.repeaterSeq;
            if (bl) {
                this.repeaterListAudio.trim(this.smoothRepeaterMinFragmentCount, this.smoothRepeaterTargetDuration, this.getLastStartTimecode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepeaterItemVideo(SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder, boolean bl) {
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            this.repeaterListVideo.addRepeaterItem(smoothStreamingRepeaterHolder);
            ++this.repeaterSeq;
            if (bl) {
                this.repeaterListVideo.trim(this.smoothRepeaterMinFragmentCount, this.smoothRepeaterTargetDuration, this.getLastStartTimecode());
            }
        }
    }

    private void addFragment(SmoothStreamingFragments smoothStreamingFragments, SmoothStreamingPendingFragment smoothStreamingPendingFragment, SmoothStreamingFragmentHeader smoothStreamingFragmentHeader, long l) {
        SmoothStreamingFragment smoothStreamingFragment = new SmoothStreamingFragment();
        smoothStreamingFragment.setStartTimecode(smoothStreamingPendingFragment.startTime);
        smoothStreamingFragment.setStopTimecode(smoothStreamingPendingFragment.startTime + smoothStreamingPendingFragment.duration);
        smoothStreamingFragment.setMediaInfoAudio(smoothStreamingPendingFragment.mediaInfoAudio);
        smoothStreamingFragment.setMediaInfoVideo(smoothStreamingPendingFragment.mediaInfoVideo);
        smoothStreamingFragment.setDuration(smoothStreamingPendingFragment.duration);
        RTPPacketFragmentList rTPPacketFragmentList = smoothStreamingFragment.getFragmentList();
        rTPPacketFragmentList.addPacketFragment(smoothStreamingFragmentHeader.getHeaderData());
        for (SmoothStreamingMediaPacket smoothStreamingMediaPacket : smoothStreamingPendingFragment.frames) {
            rTPPacketFragmentList.addPacketFragments(smoothStreamingMediaPacket.getFragmentList());
        }
        smoothStreamingFragments.addFragment(smoothStreamingFragment.getStartTimecode(), smoothStreamingFragment);
        smoothStreamingFragments.trim(l);
        this.updateISMCXML();
    }

    public void clearFragmentAudio() {
        this.pendingAudioFragments.clear();
        this.audioFragments.clear();
        this.updateISMCXML();
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setType(8);
        smoothStreamingRepeaterHolder.setRepeaterType(5);
        this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
    }

    public void startFragmentAudio(long l) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = new SmoothStreamingPendingFragment();
        smoothStreamingPendingFragment.startTime = l;
        smoothStreamingPendingFragment.fragmentId = this.nextFragmentIdAudio++;
        this.pendingAudioFragments.put(new Long(l), smoothStreamingPendingFragment);
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
        smoothStreamingRepeaterHolder.setType(8);
        smoothStreamingRepeaterHolder.setRepeaterType(1);
        smoothStreamingRepeaterHolder.setStartTime(l);
        this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
    }

    public void addFragmentAudioMediaPacket(long l, SmoothStreamingMediaPacket smoothStreamingMediaPacket) {
        if (smoothStreamingMediaPacket != null) {
            SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingAudioFragments.get(new Long(l));
            if (smoothStreamingPendingFragment != null) {
                smoothStreamingPendingFragment.frames.add(smoothStreamingMediaPacket);
                SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
                smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
                smoothStreamingRepeaterHolder.setType(8);
                smoothStreamingRepeaterHolder.setRepeaterType(2);
                smoothStreamingRepeaterHolder.setStartTime(l);
                smoothStreamingRepeaterHolder.setMediaPacket(smoothStreamingMediaPacket);
                this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
            } else {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.addFragmentAudioMediaPacket[" + this.getContextStr() + "]: Timecode missing: " + l);
            }
        }
    }

    private long getLastStopTimecode() {
        long l = this.audioFragments.getLastStopTimecode();
        long l2 = this.videoFragments.getLastStopTimecode();
        if (l > 0L && l2 > 0L) {
            return Math.min(l, l2);
        }
        if (l > 0L) {
            return l;
        }
        if (l2 > 0L) {
            return l2;
        }
        return -1L;
    }

    private long getLastStartTimecode() {
        long l = this.audioFragments.getLastStartTimecode();
        long l2 = this.videoFragments.getLastStartTimecode();
        if (l > 0L && l2 > 0L) {
            return Math.min(l, l2);
        }
        if (l > 0L) {
            return l;
        }
        if (l2 > 0L) {
            return l2;
        }
        return -1L;
    }

    public void setFragmentAudioHeader(long l, SmoothStreamingFragmentHeader smoothStreamingFragmentHeader, SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingAudioFragments.remove(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.mediaInfoAudio = smoothStreamingMediaInfoAudio;
            this.addFragment(this.audioFragments, smoothStreamingPendingFragment, smoothStreamingFragmentHeader, this.getLastStartTimecode());
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(8);
            smoothStreamingRepeaterHolder.setRepeaterType(3);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setFragmentHeader(smoothStreamingFragmentHeader);
            smoothStreamingRepeaterHolder.setMediaInfoAudio(smoothStreamingMediaInfoAudio);
            this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
            if (this.maxChunkLogCount == 0 || smoothStreamingPendingFragment.fragmentId <= (long)this.maxChunkLogCount) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.addFragment[" + this.getContextStr() + "]: Add chunk: type:audio id:" + smoothStreamingPendingFragment.fragmentId + " count:" + smoothStreamingPendingFragment.frames.size() + " duration:" + smoothStreamingPendingFragment.duration / 10000L);
            }
        }
    }

    public long recalculateDuration(SmoothStreamingPendingFragment smoothStreamingPendingFragment, long l) {
        Iterator<SmoothStreamingMediaPacket> iterator = smoothStreamingPendingFragment.frames.iterator();
        long l2 = 0L;
        long l3 = -1L;
        long l4 = 0L;
        while (iterator.hasNext()) {
            SmoothStreamingMediaPacket smoothStreamingMediaPacket = iterator.next();
            long l5 = smoothStreamingMediaPacket.getTimecode();
            if (l3 >= 0L) {
                long l6 = l5 - l3;
                if (l6 < 0L) {
                    l6 = l4;
                } else {
                    l4 = l6;
                }
                l2 += l6;
            }
            l3 = l5;
        }
        if (l3 >= 0L) {
            long l7 = l - l3;
            if (l7 < 0L) {
                l7 = l4;
            }
            l2 += l7;
        }
        return l2;
    }

    public void endFragmentAudio(long l, long l2) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingAudioFragments.get(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.duration = l2 - l;
            if (smoothStreamingPendingFragment.duration < 0L) {
                smoothStreamingPendingFragment.duration = this.recalculateDuration(smoothStreamingPendingFragment, l2);
            }
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(8);
            smoothStreamingRepeaterHolder.setRepeaterType(4);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setEndTime(l2);
            this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, true);
        } else {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.endFragmentAudio[" + this.getContextStr() + "]: Timecode missing: " + l);
        }
    }

    public void clearFragmentVideo() {
        this.pendingVideoFragments.clear();
        this.videoFragments.clear();
        this.updateISMCXML();
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setType(9);
        smoothStreamingRepeaterHolder.setRepeaterType(5);
        this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
    }

    public void startFragmentVideo(long l) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = new SmoothStreamingPendingFragment();
        smoothStreamingPendingFragment.startTime = l;
        smoothStreamingPendingFragment.fragmentId = this.nextFragmentIdVideo++;
        this.pendingVideoFragments.put(new Long(l), smoothStreamingPendingFragment);
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
        smoothStreamingRepeaterHolder.setType(9);
        smoothStreamingRepeaterHolder.setRepeaterType(1);
        smoothStreamingRepeaterHolder.setStartTime(l);
        this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
    }

    public void addFragmentVideoMediaPacket(long l, SmoothStreamingMediaPacket smoothStreamingMediaPacket) {
        if (smoothStreamingMediaPacket != null) {
            SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingVideoFragments.get(new Long(l));
            if (smoothStreamingPendingFragment != null) {
                smoothStreamingPendingFragment.frames.add(smoothStreamingMediaPacket);
                SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
                smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
                smoothStreamingRepeaterHolder.setType(9);
                smoothStreamingRepeaterHolder.setRepeaterType(2);
                smoothStreamingRepeaterHolder.setStartTime(l);
                smoothStreamingRepeaterHolder.setMediaPacket(smoothStreamingMediaPacket);
                this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
            } else {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.addFragmentVideoMediaPacket[" + this.getContextStr() + "]: Timecode missing: " + l);
            }
        }
    }

    public void setFragmentVideoHeader(long l, SmoothStreamingFragmentHeader smoothStreamingFragmentHeader, SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingVideoFragments.remove(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.mediaInfoVideo = smoothStreamingMediaInfoVideo;
            this.addFragment(this.videoFragments, smoothStreamingPendingFragment, smoothStreamingFragmentHeader, this.getLastStartTimecode());
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(9);
            smoothStreamingRepeaterHolder.setRepeaterType(3);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setFragmentHeader(smoothStreamingFragmentHeader);
            smoothStreamingRepeaterHolder.setMediaInfoVideo(smoothStreamingMediaInfoVideo);
            this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
            if (this.maxChunkLogCount == 0 || smoothStreamingPendingFragment.fragmentId <= (long)this.maxChunkLogCount) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.addFragment[" + this.getContextStr() + "]: Add chunk: type:video id:" + smoothStreamingPendingFragment.fragmentId + " count:" + smoothStreamingPendingFragment.frames.size() + " duration:" + smoothStreamingPendingFragment.duration / 10000L);
            }
        }
    }

    public void endFragmentVideo(long l, long l2) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingVideoFragments.get(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.duration = l2 - l;
            if (smoothStreamingPendingFragment.duration < 0L) {
                smoothStreamingPendingFragment.duration = this.recalculateDuration(smoothStreamingPendingFragment, l2);
            }
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(9);
            smoothStreamingRepeaterHolder.setRepeaterType(4);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setEndTime(l2);
            this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, true);
        } else {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.endFragmentVideo[" + this.getContextStr() + "]: Timecode missing: " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateISMCXML() {
        block41: {
            try {
                Object object;
                Object object2;
                String string;
                Object object3;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                StringBuffer stringBuffer = new StringBuffer();
                String string5 = "";
                String string6 = "";
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                int n = this.videoFragments.size();
                int n2 = this.audioFragments.size();
                int n3 = this.dataTracks.getDataTrackCount();
                if (n <= 0 && n2 <= 0) break block41;
                long[] lArray = this.audioFragments.getStartStopTimecodes(this.smoothManifestMinFragmentCount);
                long[] lArray2 = this.videoFragments.getStartStopTimecodes(this.smoothManifestMinFragmentCount);
                long l = this.smoothManifestTargetDuration * 10000;
                if (lArray != null) {
                    l = Math.max(l, lArray[2]);
                }
                if (lArray2 != null) {
                    l = Math.max(l, lArray2[2]);
                }
                long l2 = -1L;
                long l3 = -1L;
                if (lArray != null && lArray2 != null) {
                    long l4 = Math.max(lArray[0], lArray2[0]);
                    long l5 = Math.min(lArray[1], lArray2[1]);
                    long l6 = l5 - l4;
                    if (l6 >= l) {
                        l3 = l5;
                        l2 = l3 - l;
                        if (l2 < 0L) {
                            l2 = 0L;
                            l3 = l2 + l;
                        }
                    } else if (l6 > 0L) {
                        l2 = l4;
                        l3 = l2 + l;
                        if (l3 > Math.max(lArray[1], lArray2[1]) && (l2 = (l3 = Math.max(lArray[1], lArray2[1])) - l) < 0L) {
                            l2 = 0L;
                            l3 = l2 + l;
                        }
                    } else {
                        l3 = Math.max(lArray[1], lArray2[1]);
                        l2 = l3 - l;
                        if (l2 < 0L) {
                            l2 = 0L;
                            l3 = l2 + l;
                        }
                    }
                } else if (lArray != null) {
                    l3 = lArray[1];
                    l2 = l3 - l;
                    if (l2 < 0L) {
                        l2 = 0L;
                        l3 = l2 + l;
                    }
                } else if (lArray2 != null && (l2 = (l3 = lArray2[1]) - l) < 0L) {
                    l2 = 0L;
                    l3 = l2 + l;
                }
                string2 = "<SmoothStreamingMedia MajorVersion=\"" + this.smoothStreamingMediaMajorVersion + "\" MinorVersion=\"" + this.smoothStreamingMediaMinorVersion + "\" Duration=\"0\" Timescale=\"10000000\" LookAheadFragmentCount=\"" + this.readAheadSize + "\" DVRWindowLength=\"0\" IsLive=\"TRUE\">" + "\n";
                if (n2 > 0) {
                    Object object4;
                    object3 = object4 = this.audioFragments.getLock();
                    synchronized (object3) {
                        SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = this.audioFragments.getMediaInfoAudio();
                        string5 = "<StreamIndex Type=\"audio\" Index=\"0\" Chunks=\"0\" Timescale=\"10000000\" QualityLevels=\"1\" Url=\"QualityLevels({bitrate})/Fragments(audio={start time})/WowzaSessions({sessionid}).isma\">\n";
                        string = "";
                        if (smoothStreamingMediaInfoAudio.getAudioWaveFormatEx() != null) {
                            string = " CodecPrivateData=\"" + BufferUtils.encodeHexString((byte[])smoothStreamingMediaInfoAudio.getAudioWaveFormatEx()) + "\"";
                        }
                        String string7 = smoothStreamingMediaInfoAudio.getAudioFourCC();
                        string6 = "<QualityLevel Bitrate=\"{audiobitrate}\" FourCC=\"" + string7 + "\" SamplingRate=\"" + smoothStreamingMediaInfoAudio.getAudioSamplingRate() + "\" Channels=\"" + smoothStreamingMediaInfoAudio.getAudioChannels() + "\" BitsPerSample=\"" + smoothStreamingMediaInfoAudio.getAudioBitsPerSample() + "\" PacketSize=\"" + smoothStreamingMediaInfoAudio.getAudioPacketSize() + "\" AudioTag=\"" + smoothStreamingMediaInfoAudio.getAudioTag() + "\"" + string + " />" + "\n";
                        object2 = this.audioFragments.getTimeInfo(l2, l3, this.smoothManifestMinFragmentCount);
                        Iterator<long[]> iterator = object2.iterator();
                        int n4 = 0;
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            String string8 = "";
                            if (++n4 == object2.size()) {
                                string8 = " d=\"" + (object[1] - object[0]) + "\"";
                            }
                            stringBuffer2.append("<c t=\"" + object[0] + "\"" + string8 + "/>" + "\n");
                        }
                    }
                }
                if (n > 0) {
                    Object object5;
                    object3 = object5 = this.videoFragments.getLock();
                    synchronized (object3) {
                        SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = this.videoFragments.getMediaInfoVideo();
                        string3 = "<StreamIndex Type=\"video\" Chunks=\"0\" Timescale=\"10000000\" QualityLevels=\"1\" MaxWidth=\"" + smoothStreamingMediaInfoVideo.getVideoWidth() + "\" MaxHeight=\"" + smoothStreamingMediaInfoVideo.getVideoHeight() + "\" DisplayWidth=\"" + smoothStreamingMediaInfoVideo.getDisplayWidth() + "\" DisplayHeight=\"" + smoothStreamingMediaInfoVideo.getDisplayHeight() + "\" Url=\"QualityLevels({bitrate})/Fragments(video={start time})/WowzaSessions(" + "{sessionid}" + ").ismv\">" + "\n";
                        string = "";
                        if (smoothStreamingMediaInfoVideo.getVideoCodecPrivateData() != null) {
                            string = " CodecPrivateData=\"" + BufferUtils.encodeHexString((byte[])smoothStreamingMediaInfoVideo.getVideoCodecPrivateData()) + "\"";
                        }
                        string4 = "<QualityLevel Index=\"0\" Bitrate=\"{videobitrate}\" FourCC=\"" + smoothStreamingMediaInfoVideo.getVideoFourCC() + "\" MaxWidth=\"" + smoothStreamingMediaInfoVideo.getVideoWidth() + "\" MaxHeight=\"" + smoothStreamingMediaInfoVideo.getVideoHeight() + "\"" + string + " />" + "\n";
                        List<long[]> list = this.videoFragments.getTimeInfo(l2, l3, this.smoothManifestMinFragmentCount);
                        object2 = list.iterator();
                        int n5 = 0;
                        while (object2.hasNext()) {
                            long[] lArray3 = (long[])object2.next();
                            object = "";
                            if (++n5 == list.size()) {
                                object = " d=\"" + (lArray3[1] - lArray3[0]) + "\"";
                            }
                            stringBuffer.append("<c t=\"" + lArray3[0] + "\"" + (String)object + "/>" + "\n");
                        }
                    }
                }
                if (n3 > 0) {
                    LiveStreamPacketizerSmoothStreamerUtils.formatDataTracks(stringBuffer3, this.dataTracks);
                }
                if (this.playReadyKeyInfo != null) {
                    String string9 = "";
                    object3 = this.playReadyKeyInfo.getProtectionHeaderBytes();
                    if (object3 != null) {
                        string9 = Base64.encodeBytes((byte[])object3, (int)8);
                    }
                    stringBuffer4.append("<Protection>\n");
                    stringBuffer4.append("<ProtectionHeader SystemID=\"9A04F079-9840-4286-AB92-E65BE0885F95\">" + string9 + "</ProtectionHeader>" + "\n");
                    stringBuffer4.append("</Protection>\n");
                }
                StringBuffer stringBuffer5 = new StringBuffer();
                object3 = this.ismcXMLLock;
                synchronized (object3) {
                    stringBuffer5.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                    stringBuffer5.append(string2);
                    this.xmlSmoothStreamingMedia = string2.toString();
                    boolean bl = this.xmlIsAudio = n2 > 0;
                    if (this.xmlIsAudio) {
                        stringBuffer5.append(string5);
                        stringBuffer5.append(string6);
                        stringBuffer5.append(stringBuffer2);
                        stringBuffer5.append("</StreamIndex>\n");
                    }
                    boolean bl2 = this.xmlIsVideo = n > 0;
                    if (this.xmlIsVideo) {
                        stringBuffer5.append(string3);
                        stringBuffer5.append(string4);
                        stringBuffer5.append(stringBuffer);
                        stringBuffer5.append("</StreamIndex>\n");
                    }
                    this.xmlStreamIndexVideo = string3.toString();
                    this.xmlQualityLevelVideo = string4.toString();
                    this.xmlSamplesVideo = stringBuffer.toString();
                    this.xmlStreamIndexAudio = string5.toString();
                    this.xmlQualityLevelAudio = string6.toString();
                    this.xmlSamplesAudio = stringBuffer2.toString();
                    boolean bl3 = this.xmlIsData = n3 > 0;
                    if (this.xmlIsData) {
                        stringBuffer5.append(stringBuffer3);
                    }
                    this.xmlData = stringBuffer3.toString();
                    boolean bl4 = this.xmlIsProtection = stringBuffer4.length() > 0;
                    if (this.xmlIsProtection) {
                        stringBuffer5.append(stringBuffer4);
                    }
                    this.xmlProtection = stringBuffer4.toString();
                    stringBuffer5.append("</SmoothStreamingMedia>\n");
                    this.xmlISMC = stringBuffer5.toString();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.updateISMCXML: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoBitrate() {
        Object object;
        int n = 0;
        Object object2 = object = this.videoFragments.getLock();
        synchronized (object2) {
            SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = this.videoFragments.getMediaInfoVideo();
            if (smoothStreamingMediaInfoVideo != null) {
                n = smoothStreamingMediaInfoVideo.getVideoBitrate();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAudioBitrate() {
        Object object;
        int n = 0;
        Object object2 = object = this.audioFragments.getLock();
        synchronized (object2) {
            SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = this.audioFragments.getMediaInfoAudio();
            if (smoothStreamingMediaInfoAudio != null) {
                n = smoothStreamingMediaInfoAudio.getAudioBitrate();
            }
        }
        return n;
    }

    public RTPPacketFragmentList getAudioPacket(long l, boolean bl) {
        return this.audioFragments.getFragmentBytes(l, bl);
    }

    public RTPPacketFragmentList getVideoPacket(long l, boolean bl) {
        return this.getVideoPacket(l, bl, 0);
    }

    public RTPPacketFragmentList getVideoPacket(long l, boolean bl, int n) {
        return this.videoFragments.getFragmentBytes(l, bl, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLSmoothStreamingMedia() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlSmoothStreamingMedia;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLIsVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlIsVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLStreamIndexVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlStreamIndexVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLQualityLevelVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlQualityLevelVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLSamplesVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlSamplesVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLIsAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlIsAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLIsData() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlIsData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLIsProtection() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlIsProtection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLStreamIndexAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlStreamIndexAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLQualityLevelAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlQualityLevelAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLSamplesAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlSamplesAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLData() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLProtection() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlProtection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLISMC() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlISMC;
        }
    }

    public long getPlaylistDuration() {
        return Math.max(this.videoFragments.getDuration(), this.audioFragments.getDuration()) / 10000L;
    }

    public boolean testPlaylistDuration(long l) {
        long l2 = this.getPlaylistDuration();
        boolean bl = l == 0L || l2 >= l;
        return bl;
    }

    public SmoothStreamingDataTracks getDataTracks() {
        return this.dataTracks;
    }
}

