/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import java.net.URI;
import java.util.ArrayList;

public class SanJoseStreamingURL {
    private String url = null;
    private String streamName = "";
    private String appName = "_defapp_";
    private String appInstanceName = "_definst_";
    private String queryStr = "";
    private String host = null;
    private String domain = null;

    public SanJoseStreamingURL(String string) {
        this.url = string;
        this.decode(0);
    }

    public SanJoseStreamingURL(String string, int n) {
        if (string.indexOf("://") < 0 && string.indexOf(":/") >= 0) {
            string = string.replace(":/", "://127.0.0.1/");
        }
        this.url = string;
        this.decode(n);
    }

    public void decode(int n) {
        if (this.url.indexOf("://") >= 0) {
            this.decodeURL(n);
        } else {
            this.decodeNonURL(n);
        }
    }

    public void decodeNonURL(int n) {
        String string = this.url;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.decodePath(string, n);
    }

    public void decodePath(String string, int n) {
        if (string != null) {
            int n2;
            int n3 = string.indexOf("?");
            if (n3 >= 0) {
                this.queryStr = string.substring(n3 + 1);
                string = string.substring(0, n3);
            }
            String[] stringArray = string.split("/");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string2 = stringArray[n2].trim();
                if (string2.length() == 0) continue;
                arrayList.add(string2);
            }
            for (n2 = arrayList.size(); n > 0 && n2 > 0; --n2, --n) {
            }
            if (n2 == 1) {
                this.streamName = (String)arrayList.get(0);
            } else if (n2 == 2) {
                this.appName = (String)arrayList.get(0);
                this.streamName = (String)arrayList.get(1);
            } else if (n2 > 2) {
                this.appName = (String)arrayList.get(0);
                this.appInstanceName = (String)arrayList.get(1);
                this.streamName = "";
                for (int i = 2; i < n2; ++i) {
                    if (this.streamName.length() > 0) {
                        this.streamName = this.streamName + "/";
                    }
                    this.streamName = this.streamName + (String)arrayList.get(i);
                }
            }
        }
    }

    public void decodeURL(int n) {
        block4: {
            URI uRI = null;
            try {
                uRI = new URI(this.url);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPResponseMessage.class).warn("RTSPCore.announce: context url is bad format(" + this.url + "): " + exception.toString());
                break block4;
            }
            if (uRI.getQuery() != null) {
                this.queryStr = uRI.getQuery();
            }
            this.host = uRI.getHost();
            this.domain = uRI.getHost();
            if (uRI.getPort() > 0) {
                this.domain = this.domain + ":" + uRI.getPort();
            }
            this.streamName = "";
            this.appName = "_defapp_";
            this.appInstanceName = "_definst_";
            String string = uRI.getPath();
            this.decodePath(string, n);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppInstanceName() {
        return this.appInstanceName;
    }

    public void setAppInstanceName(String string) {
        this.appInstanceName = string;
    }

    public String getUrlId() {
        return this.getAppName() + "/" + this.getAppInstanceName() + "/" + this.streamName;
    }

    public synchronized String getQueryStr() {
        return this.queryStr;
    }

    public synchronized void setQueryStr(String string) {
        this.queryStr = string;
    }

    public String getHost() {
        return this.host;
    }

    public String getDomain() {
        return this.domain;
    }
}

