/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJoseTSHolder;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerSanJoseChunk {
    private int chunkIndex = 0;
    private List<LiveStreamingSanJoseBlock> blocks = new ArrayList<LiveStreamingSanJoseBlock>();
    private int size = 0;
    private int dataSize = 0;
    private long startTimecode = -1L;
    private long duration = 0L;
    private boolean cacheable = false;
    private String encUrl = "";
    private byte[] encRepeaterBytes = null;
    private boolean writePAT = true;
    private int audioCount = 0;
    private int videoCount = 0;
    private int videoKeyCount = 0;
    private int streamMode = 1;
    private MediaCodecInfoAudio codecInfoAudio = null;
    private MediaCodecInfoVideo codecInfoVideo = null;
    private SanJoseTSHolder metaDataHolder = null;

    public LiveStreamPacketizerSanJoseChunk(int n) {
        this.chunkIndex = n;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public void addBlock(byte[] byArray, int n, int n2) {
        this.blocks.add(new LiveStreamingSanJoseBlock(byArray, n, n2));
        this.size += n2;
    }

    public void insertBlock(int n, byte[] byArray, int n2, int n3) {
        this.blocks.add(n, new LiveStreamingSanJoseBlock(byArray, n2, n3));
        this.size += n3;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public long getStartTimecode() {
        return this.startTimecode;
    }

    public void setStartTimecode(long l) {
        this.startTimecode = l;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public List<LiveStreamingSanJoseBlock> getBlockList() {
        return this.blocks;
    }

    public void setBlockList(List<LiveStreamingSanJoseBlock> list) {
        this.blocks = list;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean bl) {
        this.cacheable = bl;
    }

    public int getBlockCount() {
        return this.blocks.size();
    }

    public String getEncUrl() {
        return this.encUrl;
    }

    public void setEncUrl(String string) {
        this.encUrl = string;
    }

    public byte[] getEncRepeaterBytes() {
        return this.encRepeaterBytes;
    }

    public void setEncRepeaterBytes(byte[] byArray) {
        this.encRepeaterBytes = byArray;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int n) {
        this.dataSize = n;
    }

    public void incDataSize(int n) {
        this.dataSize += n;
    }

    public boolean isWritePAT() {
        return this.writePAT;
    }

    public void setWritePAT(boolean bl) {
        this.writePAT = bl;
    }

    public void incAudioCount() {
        ++this.audioCount;
    }

    public void incVideoCount() {
        ++this.videoCount;
    }

    public void incVideoKeyCount() {
        ++this.videoKeyCount;
    }

    public int getAudioCount() {
        return this.audioCount;
    }

    public void setAudioCount(int n) {
        this.audioCount = n;
    }

    public int getVideoCount() {
        return this.videoCount;
    }

    public void setVideoCount(int n) {
        this.videoCount = n;
    }

    public int getVideoKeyCount() {
        return this.videoKeyCount;
    }

    public void setVideoKeyCount(int n) {
        this.videoKeyCount = n;
    }

    public int getStreamMode() {
        return this.streamMode;
    }

    public void setStreamMode(int n) {
        this.streamMode = n;
    }

    public void addRTMPHeader(int n, int n2, long l) {
        byte[] byArray = new byte[11];
        int n3 = 0;
        byArray[n3 + 0] = (byte)n;
        byArray[++n3 + 0] = (byte)(0xFF & n2 >> 16);
        byArray[n3 + 1] = (byte)(0xFF & n2 >> 8);
        byArray[n3 + 2] = (byte)(0xFF & n2);
        byArray[(n3 += 3) + 0] = (byte)(0xFFL & l >> 16);
        byArray[n3 + 1] = (byte)(0xFFL & l >> 8);
        byArray[n3 + 2] = (byte)(0xFFL & l);
        byArray[n3 + 3] = (byte)(0xFFL & l >> 24);
        byArray[(n3 += 4) + 0] = 0;
        byArray[n3 + 1] = 0;
        byArray[n3 + 2] = 0;
        n3 += 3;
        this.addBlock(byArray, 0, byArray.length);
    }

    public void addRTMPFooter(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = n + 11;
        byArray[n2 + 0] = (byte)(0xFF & n3 >> 24);
        byArray[n2 + 1] = (byte)(0xFF & n3 >> 16);
        byArray[n2 + 2] = (byte)(0xFF & n3 >> 8);
        byArray[n2 + 3] = (byte)(0xFF & n3);
        this.addBlock(byArray, 0, byArray.length);
    }

    public void addMDATHeader() {
        byte[] byArray = new byte[8];
        BufferUtils.intToByteArray((int)(this.size + 8), (byte[])byArray, (int)0, (int)4);
        System.arraycopy("mdat".getBytes(), 0, byArray, 4, 4);
        this.insertBlock(0, byArray, 0, byArray.length);
    }

    public MediaCodecInfoAudio getCodecInfoAudio() {
        return this.codecInfoAudio;
    }

    public void setCodecInfoAudio(MediaCodecInfoAudio mediaCodecInfoAudio) {
        this.codecInfoAudio = mediaCodecInfoAudio;
    }

    public MediaCodecInfoVideo getCodecInfoVideo() {
        return this.codecInfoVideo;
    }

    public void setCodecInfoVideo(MediaCodecInfoVideo mediaCodecInfoVideo) {
        this.codecInfoVideo = mediaCodecInfoVideo;
    }

    public SanJoseTSHolder getMetaDataHolder() {
        return this.metaDataHolder;
    }

    public void setMetaDataHolder(SanJoseTSHolder sanJoseTSHolder) {
        this.metaDataHolder = sanJoseTSHolder;
    }
}

