/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jmx;

import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.jmx.AbstractDynamicMBean;
import org.apache.log4j.jmx.AppenderDynamicMBean;

public class LoggerDynamicMBean
extends AbstractDynamicMBean
implements NotificationListener {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private String dDescription = "This MBean acts as a management facade for a org.apache.log4j.Logger instance.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$LoggerDynamicMBean == null ? (class$org$apache$log4j$jmx$LoggerDynamicMBean = LoggerDynamicMBean.class$("org.apache.log4j.jmx.LoggerDynamicMBean")) : class$org$apache$log4j$jmx$LoggerDynamicMBean);
    private Logger logger;
    static /* synthetic */ Class class$org$apache$log4j$jmx$LoggerDynamicMBean;
    static /* synthetic */ Class class$org$apache$log4j$Appender;

    public LoggerDynamicMBean(Logger logger) {
        this.logger = logger;
        this.buildDynamicMBeanInfo();
    }

    public void handleNotification(Notification notification, Object object) {
        cat.debug("Received notification: " + notification.getType());
        this.registerAppenderMBean((Appender)notification.getUserData());
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("HierarchyDynamicMBean(): Constructs a HierarchyDynamicMBean instance", constructorArray[0]);
        this.dAttributes.add(new MBeanAttributeInfo("name", "java.lang.String", "The name of this Logger.", true, false, false));
        this.dAttributes.add(new MBeanAttributeInfo("priority", "java.lang.String", "The priority of this logger.", true, true, false));
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("class name", "java.lang.String", "add an appender to this logger"), new MBeanParameterInfo("appender name", "java.lang.String", "name of the appender")};
        this.dOperations[0] = new MBeanOperationInfo("addAppender", "addAppender(): add an appender", mBeanParameterInfoArray, "void", 1);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(mBeanAttributeInfoArray);
        MBeanInfo mBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
        return mBeanInfo;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string.equals("addAppender")) {
            this.addAppender((String)objectArray[0], (String)objectArray[1]);
            return "Hello world.";
        }
        return null;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (string.equals("name")) {
            return this.logger.getName();
        }
        if (string.equals("priority")) {
            Level level = this.logger.getLevel();
            if (level == null) {
                return null;
            }
            return level.toString();
        }
        if (string.startsWith("appender=")) {
            try {
                return new ObjectName("log4j:" + string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                cat.error("Could not create ObjectName" + string);
            }
            catch (RuntimeException runtimeException) {
                cat.error("Could not create ObjectName" + string);
            }
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute in " + this.dClassName);
    }

    void addAppender(String string, String string2) {
        cat.debug("addAppender called with " + string + ", " + string2);
        Appender appender = (Appender)OptionConverter.instantiateByClassName(string, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = LoggerDynamicMBean.class$("org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
        appender.setName(string2);
        this.logger.addAppender(appender);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        if (string.equals("priority")) {
            if (object instanceof String) {
                String string2 = (String)object;
                Level level = this.logger.getLevel();
                level = string2.equalsIgnoreCase("NULL") ? null : OptionConverter.toLevel(string2, level);
                this.logger.setLevel(level);
            }
        } else {
            throw new AttributeNotFoundException("Attribute " + string + " not found in " + this.getClass().getName());
        }
    }

    void appenderMBeanRegistration() {
        Enumeration enumeration = this.logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            this.registerAppenderMBean(appender);
        }
    }

    void registerAppenderMBean(Appender appender) {
        String string = AbstractDynamicMBean.getAppenderName(appender);
        cat.debug("Adding AppenderMBean for appender named " + string);
        ObjectName objectName = null;
        try {
            AppenderDynamicMBean appenderDynamicMBean = new AppenderDynamicMBean(appender);
            objectName = new ObjectName("log4j", "appender", string);
            if (!this.server.isRegistered(objectName)) {
                this.registerMBean(appenderDynamicMBean, objectName);
                this.dAttributes.add(new MBeanAttributeInfo("appender=" + string, "javax.management.ObjectName", "The " + string + " appender.", true, true, false));
            }
        }
        catch (JMException jMException) {
            cat.error("Could not add appenderMBean for [" + string + "].", jMException);
        }
        catch (IntrospectionException introspectionException) {
            cat.error("Could not add appenderMBean for [" + string + "].", introspectionException);
        }
        catch (RuntimeException runtimeException) {
            cat.error("Could not add appenderMBean for [" + string + "].", runtimeException);
        }
    }

    public void postRegister(Boolean bl) {
        this.appenderMBeanRegistration();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

