/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.lf5.util.DateFormatManager;
import org.apache.log4j.lf5.viewer.FilteredLogTableModel;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.LogTableRowRenderer;

public class LogTable
extends JTable {
    private static final long serialVersionUID = 4867085140195148458L;
    protected int _rowHeight = 30;
    protected JTextArea _detailTextArea;
    protected int _numCols = 9;
    protected TableColumn[] _tableColumns = new TableColumn[this._numCols];
    protected int[] _colWidths = new int[]{40, 40, 40, 70, 70, 360, 440, 200, 60};
    protected LogTableColumn[] _colNames = LogTableColumn.getLogTableColumnArray();
    protected int _colDate = 0;
    protected int _colThread = 1;
    protected int _colMessageNum = 2;
    protected int _colLevel = 3;
    protected int _colNDC = 4;
    protected int _colCategory = 5;
    protected int _colMessage = 6;
    protected int _colLocation = 7;
    protected int _colThrown = 8;
    protected DateFormatManager _dateFormatManager = null;

    public LogTable(JTextArea jTextArea) {
        Object object;
        this.init();
        this._detailTextArea = jTextArea;
        this.setModel(new FilteredLogTableModel());
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((TableColumn)object).setCellRenderer(new LogTableRowRenderer());
            ((TableColumn)object).setPreferredWidth(this._colWidths[n]);
            this._tableColumns[n] = object;
            ++n;
        }
        object = this.getSelectionModel();
        object.addListSelectionListener(new LogTableListSelectionListener(this));
    }

    public DateFormatManager getDateFormatManager() {
        return this._dateFormatManager;
    }

    public void setDateFormatManager(DateFormatManager dateFormatManager) {
        this._dateFormatManager = dateFormatManager;
    }

    public synchronized void clearLogRecords() {
        this.getFilteredLogTableModel().clear();
    }

    public FilteredLogTableModel getFilteredLogTableModel() {
        return (FilteredLogTableModel)this.getModel();
    }

    public void setDetailedView() {
        int n;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (n = 0; n < this._numCols; ++n) {
            tableColumnModel.removeColumn(this._tableColumns[n]);
        }
        for (n = 0; n < this._numCols; ++n) {
            tableColumnModel.addColumn(this._tableColumns[n]);
        }
        this.sizeColumnsToFit(-1);
    }

    public void setView(List list) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < this._numCols; ++i) {
            tableColumnModel.removeColumn(this._tableColumns[i]);
        }
        Iterator iterator = list.iterator();
        Vector vector = this.getColumnNameAndNumber();
        while (iterator.hasNext()) {
            tableColumnModel.addColumn(this._tableColumns[vector.indexOf(iterator.next())]);
        }
        this.sizeColumnsToFit(-1);
    }

    public void setFont(Font font) {
        super.setFont(font);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            this._rowHeight = n + n / 3;
            this.setRowHeight(this._rowHeight);
        }
    }

    protected void init() {
        this.setRowHeight(this._rowHeight);
        this.setSelectionMode(0);
    }

    protected Vector getColumnNameAndNumber() {
        Vector<LogTableColumn> vector = new Vector<LogTableColumn>();
        for (int i = 0; i < this._colNames.length; ++i) {
            vector.add(i, this._colNames[i]);
        }
        return vector;
    }

    class LogTableListSelectionListener
    implements ListSelectionListener {
        protected JTable _table;

        public LogTableListSelectionListener(JTable jTable) {
            this._table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = listSelectionModel.getMinSelectionIndex();
                for (int i = 0; i < LogTable.this._numCols - 1; ++i) {
                    String string = "";
                    Object object = this._table.getModel().getValueAt(n, i);
                    if (object != null) {
                        string = object.toString();
                    }
                    stringBuffer.append(LogTable.this._colNames[i] + ":");
                    stringBuffer.append("\t");
                    if (i == LogTable.this._colThread || i == LogTable.this._colMessage || i == LogTable.this._colLevel) {
                        stringBuffer.append("\t");
                    }
                    if (i == LogTable.this._colDate || i == LogTable.this._colNDC) {
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                stringBuffer.append(LogTable.this._colNames[LogTable.this._numCols - 1] + ":\n");
                Object object = this._table.getModel().getValueAt(n, LogTable.this._numCols - 1);
                if (object != null) {
                    stringBuffer.append(object.toString());
                }
                LogTable.this._detailTextArea.setText(stringBuffer.toString());
            }
        }
    }
}

