/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class RelativeTimePatternConverter
extends LoggingEventPatternConverter {
    private CachedTimestamp lastTimestamp = new CachedTimestamp(0L, "");

    public RelativeTimePatternConverter() {
        super("Time", "time");
    }

    public static RelativeTimePatternConverter newInstance(String[] stringArray) {
        return new RelativeTimePatternConverter();
    }

    public void format(LoggingEvent loggingEvent, StringBuffer stringBuffer) {
        long l = loggingEvent.timeStamp;
        if (!this.lastTimestamp.format(l, stringBuffer)) {
            String string = Long.toString(l - LoggingEvent.getStartTime());
            stringBuffer.append(string);
            this.lastTimestamp = new CachedTimestamp(l, string);
        }
    }

    private static final class CachedTimestamp {
        private final long timestamp;
        private final String formatted;

        public CachedTimestamp(long l, String string) {
            this.timestamp = l;
            this.formatted = string;
        }

        public boolean format(long l, StringBuffer stringBuffer) {
            if (l == this.timestamp) {
                stringBuffer.append(this.formatted);
                return true;
            }
            return false;
        }
    }
}

